/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.naming;

import com.google.common.base.Preconditions;
import java.util.Locale;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Name
implements Comparable<Name> {
    public static final Name EMPTY = new Name("");
    private final String originalName;
    private final String normalisedName;

    public Name(String name) {
        Preconditions.checkNotNull((Object)name);
        this.originalName = name;
        this.normalisedName = name.toLowerCase(Locale.ENGLISH);
    }

    public boolean isEmpty() {
        return this.normalisedName.isEmpty();
    }

    public String toLowerCase() {
        return this.normalisedName;
    }

    public String toUpperCase() {
        return this.originalName.toUpperCase(Locale.ENGLISH);
    }

    @Override
    public int compareTo(Name o) {
        return this.normalisedName.compareTo(o.normalisedName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Name) {
            Name other = (Name)obj;
            return this.normalisedName.equals(other.normalisedName);
        }
        return false;
    }

    public int hashCode() {
        return this.normalisedName.hashCode();
    }

    public String toString() {
        return this.originalName;
    }
}

