/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.naming;

import com.google.common.base.Strings;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.terasology.gestalt.naming.exception.VersionParseException;

public final class Version
implements Comparable<Version> {
    public static final Version DEFAULT = new Version(1, 0, 0);
    private static final Pattern VERSION_PATTERN = Pattern.compile("(0|[1-9][0-9]*)\\.(0|[1-9][0-9]*)\\.(0|[1-9][0-9]*)(-SNAPSHOT)?");
    private int major;
    private int minor;
    private int patch;
    private boolean snapshot;

    public Version(int major, int minor, int patch) {
        this(major, minor, patch, false);
    }

    public Version(int major, int minor, int patch, boolean snapshot) {
        if (major < 0 || minor < 0 || patch < 0) {
            throw new IllegalArgumentException("Illegal version " + major + "." + minor + "." + patch + " - all version parts must be positive");
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.snapshot = snapshot;
    }

    public Version(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new VersionParseException("Invalid version '" + version + "' - must be of the form MAJOR.minor.patch");
        }
        this.major = Integer.parseInt(matcher.group(1));
        this.minor = Integer.parseInt(matcher.group(2));
        this.patch = Integer.parseInt(matcher.group(3));
        this.snapshot = !Strings.isNullOrEmpty((String)matcher.group(4));
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public Version getSnapshot() {
        if (this.snapshot) {
            return this;
        }
        return new Version(this.major, this.minor, this.patch, true);
    }

    public Version getNextMajorVersion() {
        return new Version(this.major + 1, 0, 0);
    }

    public Version getNextMinorVersion() {
        return new Version(this.major, this.minor + 1, 0);
    }

    public Version getNextPatchVersion() {
        return new Version(this.major, this.minor, this.patch + 1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Version) {
            Version other = (Version)obj;
            return other.major == this.major && other.minor == this.minor && other.patch == this.patch && other.snapshot == this.snapshot;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.snapshot);
    }

    public String toString() {
        if (this.isSnapshot()) {
            return this.major + "." + this.minor + "." + this.patch + "-SNAPSHOT";
        }
        return this.major + "." + this.minor + "." + this.patch;
    }

    @Override
    public int compareTo(Version other) {
        if (other.major != this.major) {
            return this.major - other.major;
        }
        if (other.minor != this.minor) {
            return this.minor - other.minor;
        }
        if (other.patch != this.patch) {
            return this.patch - other.patch;
        }
        if (other.snapshot && !this.snapshot) {
            return 1;
        }
        if (!other.snapshot && this.snapshot) {
            return -1;
        }
        return 0;
    }
}

