/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.naming;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.terasology.gestalt.naming.Version;

public class VersionRange {
    private final Version lowerBound;
    private final Version upperBound;

    public VersionRange(Version lowerBound, Version upperBound) {
        Preconditions.checkNotNull((Object)lowerBound);
        Preconditions.checkNotNull((Object)upperBound);
        Preconditions.checkArgument((lowerBound.compareTo(upperBound) < 0 ? 1 : 0) != 0, (Object)"upperBound must be greater than lowerBound");
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public Version getLowerBound() {
        return this.lowerBound;
    }

    public Version getUpperBound() {
        return this.upperBound;
    }

    public boolean contains(Version version) {
        return version.compareTo(this.lowerBound.getSnapshot()) >= 0 && version.compareTo(this.upperBound.getSnapshot()) < 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof VersionRange) {
            VersionRange other = (VersionRange)obj;
            return Objects.equals(this.lowerBound, other.lowerBound) && Objects.equals(this.upperBound, other.upperBound);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.lowerBound, this.upperBound);
    }

    public String toString() {
        return "[" + this.lowerBound + "," + this.upperBound + ")";
    }
}

