/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class EXTSemaphore {
    public static final int GL_NUM_DEVICE_UUIDS_EXT = 38294;
    public static final int GL_DEVICE_UUID_EXT = 38295;
    public static final int GL_DRIVER_UUID_EXT = 38296;
    public static final int GL_UUID_SIZE_EXT = 16;
    public static final int GL_LAYOUT_GENERAL_EXT = 38285;
    public static final int GL_LAYOUT_COLOR_ATTACHMENT_EXT = 38286;
    public static final int GL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT = 38287;
    public static final int GL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT = 38288;
    public static final int GL_LAYOUT_SHADER_READ_ONLY_EXT = 38289;
    public static final int GL_LAYOUT_TRANSFER_SRC_EXT = 38290;
    public static final int GL_LAYOUT_TRANSFER_DST_EXT = 38291;

    protected EXTSemaphore() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glGetUnsignedBytevEXT, caps.glGetUnsignedBytei_vEXT, caps.glGenSemaphoresEXT, caps.glDeleteSemaphoresEXT, caps.glIsSemaphoreEXT, caps.glSemaphoreParameterui64vEXT, caps.glGetSemaphoreParameterui64vEXT, caps.glWaitSemaphoreEXT, caps.glSignalSemaphoreEXT});
    }

    public static native void nglGetUnsignedBytevEXT(int var0, long var1);

    public static void glGetUnsignedBytevEXT(@NativeType(value="GLenum") int pname, @NativeType(value="GLubyte *") ByteBuffer data) {
        EXTSemaphore.nglGetUnsignedBytevEXT(pname, MemoryUtil.memAddress((ByteBuffer)data));
    }

    public static native void nglGetUnsignedBytei_vEXT(int var0, int var1, long var2);

    public static void glGetUnsignedBytei_vEXT(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int index, @NativeType(value="GLubyte *") ByteBuffer data) {
        EXTSemaphore.nglGetUnsignedBytei_vEXT(target, index, MemoryUtil.memAddress((ByteBuffer)data));
    }

    public static native void nglGenSemaphoresEXT(int var0, long var1);

    public static void glGenSemaphoresEXT(@NativeType(value="GLuint *") IntBuffer semaphores) {
        EXTSemaphore.nglGenSemaphoresEXT(semaphores.remaining(), MemoryUtil.memAddress((IntBuffer)semaphores));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGenSemaphoresEXT() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer semaphores = stack.callocInt(1);
            EXTSemaphore.nglGenSemaphoresEXT(1, MemoryUtil.memAddress((IntBuffer)semaphores));
            int n = semaphores.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDeleteSemaphoresEXT(int var0, long var1);

    public static void glDeleteSemaphoresEXT(@NativeType(value="const GLuint *") IntBuffer semaphores) {
        EXTSemaphore.nglDeleteSemaphoresEXT(semaphores.remaining(), MemoryUtil.memAddress((IntBuffer)semaphores));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteSemaphoresEXT(@NativeType(value="const GLuint *") int semaphore) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer semaphores = stack.ints(semaphore);
            EXTSemaphore.nglDeleteSemaphoresEXT(1, MemoryUtil.memAddress((IntBuffer)semaphores));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="GLboolean")
    public static native boolean glIsSemaphoreEXT(@NativeType(value="GLuint") int var0);

    public static native void nglSemaphoreParameterui64vEXT(int var0, int var1, long var2);

    public static void glSemaphoreParameterui64vEXT(@NativeType(value="GLuint") int semaphore, @NativeType(value="GLenum") int pname, @NativeType(value="const GLuint64 *") LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        EXTSemaphore.nglSemaphoreParameterui64vEXT(semaphore, pname, MemoryUtil.memAddress((LongBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glSemaphoreParameterui64EXT(@NativeType(value="GLuint") int semaphore, @NativeType(value="GLenum") int pname, @NativeType(value="const GLuint64 *") long param) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.longs(param);
            EXTSemaphore.nglSemaphoreParameterui64vEXT(semaphore, pname, MemoryUtil.memAddress((LongBuffer)params));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetSemaphoreParameterui64vEXT(int var0, int var1, long var2);

    public static void glGetSemaphoreParameterui64vEXT(@NativeType(value="GLuint") int semaphore, @NativeType(value="GLenum") int pname, @NativeType(value="GLuint64 *") LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        EXTSemaphore.nglGetSemaphoreParameterui64vEXT(semaphore, pname, MemoryUtil.memAddress((LongBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static long glGetSemaphoreParameterui64EXT(@NativeType(value="GLuint") int semaphore, @NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            EXTSemaphore.nglGetSemaphoreParameterui64vEXT(semaphore, pname, MemoryUtil.memAddress((LongBuffer)params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglWaitSemaphoreEXT(int var0, int var1, long var2, int var4, long var5, long var7);

    public static void glWaitSemaphoreEXT(@NativeType(value="GLuint") int semaphore, @NativeType(value="const GLuint *") IntBuffer buffers, @NativeType(value="const GLuint *") IntBuffer textures, @NativeType(value="const GLenum *") IntBuffer srcLayouts) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)srcLayouts, (int)textures.remaining());
        }
        EXTSemaphore.nglWaitSemaphoreEXT(semaphore, buffers.remaining(), MemoryUtil.memAddress((IntBuffer)buffers), textures.remaining(), MemoryUtil.memAddress((IntBuffer)textures), MemoryUtil.memAddress((IntBuffer)srcLayouts));
    }

    public static native void nglSignalSemaphoreEXT(int var0, int var1, long var2, int var4, long var5, long var7);

    public static void glSignalSemaphoreEXT(@NativeType(value="GLuint") int semaphore, @NativeType(value="const GLuint *") IntBuffer buffers, @NativeType(value="const GLuint *") IntBuffer textures, @NativeType(value="const GLenum *") IntBuffer dstLayouts) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)dstLayouts, (int)textures.remaining());
        }
        EXTSemaphore.nglSignalSemaphoreEXT(semaphore, buffers.remaining(), MemoryUtil.memAddress((IntBuffer)buffers), textures.remaining(), MemoryUtil.memAddress((IntBuffer)textures), MemoryUtil.memAddress((IntBuffer)dstLayouts));
    }

    public static void glGenSemaphoresEXT(@NativeType(value="GLuint *") int[] semaphores) {
        long __functionAddress = GL.getICD().glGenSemaphoresEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)semaphores.length, (int[])semaphores);
    }

    public static void glDeleteSemaphoresEXT(@NativeType(value="const GLuint *") int[] semaphores) {
        long __functionAddress = GL.getICD().glDeleteSemaphoresEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)semaphores.length, (int[])semaphores);
    }

    public static void glSemaphoreParameterui64vEXT(@NativeType(value="GLuint") int semaphore, @NativeType(value="GLenum") int pname, @NativeType(value="const GLuint64 *") long[] params) {
        long __functionAddress = GL.getICD().glSemaphoreParameterui64vEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)semaphore, (int)pname, (long[])params);
    }

    public static void glGetSemaphoreParameterui64vEXT(@NativeType(value="GLuint") int semaphore, @NativeType(value="GLenum") int pname, @NativeType(value="GLuint64 *") long[] params) {
        long __functionAddress = GL.getICD().glGetSemaphoreParameterui64vEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)semaphore, (int)pname, (long[])params);
    }

    public static void glWaitSemaphoreEXT(@NativeType(value="GLuint") int semaphore, @NativeType(value="const GLuint *") int[] buffers, @NativeType(value="const GLuint *") int[] textures, @NativeType(value="const GLenum *") int[] srcLayouts) {
        long __functionAddress = GL.getICD().glWaitSemaphoreEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])srcLayouts, (int)textures.length);
        }
        JNI.callPPPV((long)__functionAddress, (int)semaphore, (int)buffers.length, (int[])buffers, (int)textures.length, (int[])textures, (int[])srcLayouts);
    }

    public static void glSignalSemaphoreEXT(@NativeType(value="GLuint") int semaphore, @NativeType(value="const GLuint *") int[] buffers, @NativeType(value="const GLuint *") int[] textures, @NativeType(value="const GLenum *") int[] dstLayouts) {
        long __functionAddress = GL.getICD().glSignalSemaphoreEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])dstLayouts, (int)textures.length);
        }
        JNI.callPPPV((long)__functionAddress, (int)semaphore, (int)buffers.length, (int[])buffers, (int)textures.length, (int[])textures, (int[])dstLayouts);
    }

    static {
        GL.initialize();
    }
}

