/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.util.collection;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.terasology.gestalt.util.collection.CircularDependencyException;
import org.terasology.gestalt.util.collection.TopologicalSorter;

public class KahnSorter<T>
implements TopologicalSorter<T> {
    private Set<T> openNodes = Sets.newLinkedHashSet();
    private ListMultimap<T, T> dependentsLookup = ArrayListMultimap.create();
    private Map<T, Integer> dependencyCount = Maps.newLinkedHashMap();

    @Override
    public void addNode(T node) {
        this.openNodes.add(node);
    }

    @Override
    public void addNodes(Collection<T> nodes) {
        this.openNodes.addAll(nodes);
    }

    @Override
    public void addEdge(T fromNode, T toNode) {
        this.openNodes.remove(toNode);
        this.dependentsLookup.put(fromNode, toNode);
        if (this.dependencyCount.containsKey(toNode)) {
            this.dependencyCount.put(toNode, this.dependencyCount.get(toNode) + 1);
        } else {
            this.dependencyCount.put(toNode, 1);
        }
    }

    @Override
    public List<T> sort() {
        ArrayList resultList = Lists.newArrayList();
        while (!this.openNodes.isEmpty()) {
            T node = this.openNodes.iterator().next();
            this.openNodes.remove(node);
            resultList.add(node);
            for (Object dependent : this.dependentsLookup.removeAll(node)) {
                int dependencies = 0;
                if (this.dependencyCount.containsKey(dependent)) {
                    dependencies = this.dependencyCount.get(dependent) - 1;
                    this.dependencyCount.put(dependent, dependencies);
                } else {
                    this.dependencyCount.put(dependent, 0);
                }
                if (dependencies != 0) continue;
                this.openNodes.add(dependent);
            }
        }
        if (!this.dependentsLookup.isEmpty()) {
            throw new CircularDependencyException("Could not sort nodes, one or more circular dependencies exist involving: " + this.dependentsLookup.keySet());
        }
        return resultList;
    }
}

