/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.util.collection;

import android.support.annotation.NonNull;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class TypeKeyedMap<T> {
    private static TypeKeyedMap EMPTY = new TypeKeyedMap(Collections.emptyMap());
    private Map<Class<? extends T>, T> inner;

    public TypeKeyedMap() {
        this(Maps::newLinkedHashMap);
    }

    public static <T> TypeKeyedMap<T> empty() {
        return EMPTY;
    }

    public TypeKeyedMap(Supplier<Map<Class<? extends T>, T>> mapSupplier) {
        this(mapSupplier.get());
    }

    public TypeKeyedMap(Collection<T> values) {
        this.inner = Maps.newLinkedHashMapWithExpectedSize((int)values.size());
        values.forEach(this::put);
    }

    public TypeKeyedMap(Map<Class<? extends T>, T> baseMap) {
        this.inner = baseMap;
    }

    public int size() {
        return this.inner.size();
    }

    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    public boolean containsKey(Class<? extends T> key) {
        return this.inner.containsKey(key);
    }

    public <U extends T> boolean containsValue(U value) {
        return this.inner.containsValue(value);
    }

    public <U extends T> U get(Class<U> key) {
        return key.cast(this.inner.get(key));
    }

    public <U extends T> U put(Class<U> key, U value) {
        return (U)this.inner.put(key, value);
    }

    public <U extends T> U put(U value) {
        return (U)this.inner.put(value.getClass(), value);
    }

    public <U extends T> U remove(Class<U> key) {
        return key.cast(this.inner.remove(key));
    }

    public void clear() {
        this.inner.clear();
    }

    public Set<Class<? extends T>> keySet() {
        return this.inner.keySet();
    }

    public Collection<T> values() {
        return this.inner.values();
    }

    public Set<Entry<? extends T>> entrySet() {
        return new EntrySet(this.inner.entrySet());
    }

    public void forEach(EntryConsumer<T> action) {
        for (Entry<T> entry : this.entrySet()) {
            entry.handle(action);
        }
    }

    public Map<Class<? extends T>, T> getInner() {
        return this.inner;
    }

    public void putAll(TypeKeyedMap<T> other) {
        this.inner.putAll(other.inner);
    }

    public void putAll(Collection<T> other) {
        for (T item : other) {
            this.put(item);
        }
    }

    public static class Entry<T> {
        private Map.Entry<Class<T>, T> innerEntry;

        private Entry(Map.Entry<Class<T>, T> innerEntry) {
            this.innerEntry = innerEntry;
        }

        public Class<T> getKey() {
            return this.innerEntry.getKey();
        }

        public T getValue() {
            return this.innerEntry.getValue();
        }

        private Map.Entry<Class<T>, T> getInnerEntry() {
            return this.innerEntry;
        }

        public void handle(EntryConsumer<? super T> action) {
            action.accept(this.getKey(), this.getValue());
        }
    }

    private static class EntrySetIterator<T>
    implements Iterator<Entry<? extends T>> {
        private Iterator<Map.Entry<Class<? extends T>, T>> inner;

        private EntrySetIterator(Iterator<Map.Entry<Class<? extends T>, T>> iterator) {
            this.inner = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.inner.hasNext();
        }

        @Override
        public Entry<? extends T> next() {
            Map.Entry<Class<? extends T>, T> next = this.inner.next();
            return new Entry(next);
        }
    }

    private static class EntrySet<T>
    implements Set<Entry<T>> {
        private Set<Map.Entry<Class<? extends T>, T>> innerSet;

        private EntrySet(Set<Map.Entry<Class<? extends T>, T>> inner) {
            this.innerSet = inner;
        }

        @Override
        public int size() {
            return this.innerSet.size();
        }

        @Override
        public boolean isEmpty() {
            return this.innerSet.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.innerSet.contains(o);
        }

        @Override
        @NonNull
        public Iterator<Entry<T>> iterator() {
            return new EntrySetIterator(this.innerSet.iterator());
        }

        @Override
        @NonNull
        public Object[] toArray() {
            return this.innerSet.toArray();
        }

        @Override
        @NonNull
        public <T> T[] toArray(T[] a) {
            return this.innerSet.toArray(a);
        }

        @Override
        public boolean add(Entry<T> tEntry) {
            throw new UnsupportedOperationException("Cannot add to entry set");
        }

        @Override
        public boolean remove(Object o) {
            return o instanceof Entry && this.innerSet.remove(((Entry)o).getInnerEntry());
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Entry<T>> c) {
            throw new UnsupportedOperationException("Cannot add to entry set");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.innerSet.clear();
        }
    }

    @FunctionalInterface
    public static interface EntryConsumer<T> {
        public <U extends T> void accept(Class<U> var1, U var2);
    }
}

