/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.util.collection;

import com.google.common.collect.Iterators;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;

public class UniqueQueue<T>
implements Queue<T> {
    private final Set<T> containedSet;
    private final Queue<T> internalQueue;

    public UniqueQueue() {
        this(Sets.newHashSet(), Queues.newArrayDeque());
    }

    private UniqueQueue(Set<T> internalSet, Queue<T> internalQueue) {
        this.containedSet = internalSet;
        this.internalQueue = internalQueue;
    }

    public static <T> UniqueQueue<T> create() {
        return new UniqueQueue<T>();
    }

    public static <T> UniqueQueue<T> createWithExpectedSize(int size) {
        return new UniqueQueue<T>(Sets.newHashSetWithExpectedSize((int)size), Queues.newArrayDeque());
    }

    @Override
    public int size() {
        return this.containedSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.containedSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.containedSet.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.unmodifiableIterator(this.internalQueue.iterator());
    }

    @Override
    public Object[] toArray() {
        return this.internalQueue.toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.internalQueue.toArray(a);
    }

    @Override
    public boolean add(T t) {
        return this.containedSet.add(t) && this.internalQueue.add(t);
    }

    @Override
    public boolean remove(Object o) {
        return this.containedSet.remove(o) && this.internalQueue.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.containedSet.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean changed = false;
        for (T item : c) {
            if (!this.containedSet.add(item)) continue;
            this.internalQueue.add(item);
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.containedSet.removeAll(c) && this.internalQueue.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.containedSet.retainAll(c) && this.internalQueue.retainAll(c);
    }

    @Override
    public void clear() {
        this.containedSet.clear();
        this.internalQueue.clear();
    }

    @Override
    public boolean offer(T t) {
        return this.containedSet.add(t) && this.internalQueue.offer(t);
    }

    @Override
    public T remove() {
        T result = this.internalQueue.remove();
        this.containedSet.remove(result);
        return result;
    }

    @Override
    public T poll() {
        T result = this.internalQueue.poll();
        this.containedSet.remove(result);
        return result;
    }

    @Override
    public T element() {
        return this.internalQueue.element();
    }

    @Override
    public T peek() {
        return this.internalQueue.peek();
    }
}

