/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.util.io;

import android.support.annotation.RequiresApi;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collection;
import java.util.Set;
import org.terasology.gestalt.util.Varargs;

@RequiresApi(value=26)
public class FileExtensionPathMatcher
implements PathMatcher {
    private final Set<String> extensions;

    public FileExtensionPathMatcher(String extension, String ... extensions) {
        this((Collection<String>)Varargs.combineToSet(extension, extensions));
    }

    public FileExtensionPathMatcher(Collection<String> extensions) {
        Preconditions.checkNotNull(extensions);
        Preconditions.checkArgument((!extensions.isEmpty() ? 1 : 0) != 0, (Object)"At least one extension must be provided");
        this.extensions = Sets.newHashSet(extensions);
    }

    @Override
    public boolean matches(Path path) {
        Path fileName = path.getFileName();
        if (fileName != null) {
            return this.extensions.contains(Files.getFileExtension((String)fileName.toString()));
        }
        return false;
    }
}

