/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.util.io;

import android.support.annotation.RequiresApi;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;

@RequiresApi(value=26)
public final class FileScanning {
    private FileScanning() {
    }

    public static List<Path> findFilesInPath(Path rootPath, PathMatcher scanFilter, PathMatcher fileFilter) throws IOException {
        final ImmutableList.Builder resultBuilder = ImmutableList.builder();
        Files.walkFileTree(rootPath, new FilteredFileVisitor(scanFilter, fileFilter){

            @Override
            protected void onMatch(Path file) {
                resultBuilder.add((Object)file);
            }
        });
        return resultBuilder.build();
    }

    public static abstract class FilteredFileVisitor
    extends SimpleFileVisitor<Path> {
        private PathMatcher directoryFilter;
        private PathMatcher fileFilter;

        public FilteredFileVisitor(PathMatcher directoryFilter, PathMatcher fileFilter) {
            this.directoryFilter = directoryFilter;
            this.fileFilter = fileFilter;
        }

        protected abstract void onMatch(Path var1);

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (this.directoryFilter.matches(dir)) {
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.SKIP_SUBTREE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (this.fileFilter.matches(file)) {
                this.onMatch(file);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

