/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.util.io;

import android.support.annotation.RequiresApi;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

@RequiresApi(value=26)
public class FileTypesFilter
implements DirectoryStream.Filter<Path> {
    private final ImmutableList<String> fileTypes;

    public FileTypesFilter(String fileType, String ... fileTypes) {
        Preconditions.checkNotNull((Object)fileType);
        Preconditions.checkNotNull((Object)fileTypes);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!fileType.startsWith(".")) {
            builder.add((Object)("." + fileType));
        } else {
            builder.add((Object)fileType);
        }
        for (String type : fileTypes) {
            if (!type.startsWith(".")) {
                builder.add((Object)("." + type));
                continue;
            }
            builder.add((Object)type);
        }
        this.fileTypes = builder.build();
    }

    @Override
    public boolean accept(Path entry) throws IOException {
        if (Files.isRegularFile(entry, new LinkOption[0])) {
            String entryAsString = entry.toString();
            for (String type : this.fileTypes) {
                if (!entryAsString.endsWith(type)) continue;
                return true;
            }
        }
        return false;
    }
}

