/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.util.reflection;

import com.googlecode.gentyref.GenericTypeReflector;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Optional;

public final class GenericsUtil {
    private GenericsUtil() {
    }

    public static Optional<Type> getTypeParameterBinding(Type target, int index) {
        Class<?> classOfType = GenericsUtil.getClassOfType(target);
        if (classOfType != null) {
            return GenericsUtil.getTypeParameterBindingForInheritedClass(target, classOfType, index);
        }
        throw new IllegalArgumentException("Unsupported type: " + target);
    }

    public static <T> Optional<Type> getTypeParameterBindingForInheritedClass(Type target, Class<T> superClass, int index) {
        ParameterizedType parameterizedType;
        Type paramType;
        if (superClass.getTypeParameters().length == 0) {
            throw new IllegalArgumentException("Class '" + superClass + "' is not parameterized");
        }
        Class<?> classOfType = GenericsUtil.getClassOfType(target);
        if (classOfType == null) {
            throw new IllegalArgumentException("Unsupported type: " + target);
        }
        if (!superClass.isAssignableFrom(classOfType)) {
            throw new IllegalArgumentException("Class '" + target + "' does not implement '" + superClass + "'");
        }
        Type type = GenericTypeReflector.getExactSuperType((Type)target, superClass);
        if (type instanceof ParameterizedType && ((paramType = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()[index]) instanceof Class || paramType instanceof ParameterizedType)) {
            return Optional.of(paramType);
        }
        return Optional.empty();
    }

    public static Class<?> getClassOfType(Type type) {
        Type[] upperBounds;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()).length == 1) {
            return GenericsUtil.getClassOfType(upperBounds[0]);
        }
        return null;
    }
}

