/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.util.reflection;

import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.util.reflection.ClassFactory;
import org.terasology.gestalt.util.reflection.GenericsUtil;
import org.terasology.gestalt.util.reflection.ParameterProvider;

public class SimpleClassFactory
implements ClassFactory {
    private static final Logger logger = LoggerFactory.getLogger(SimpleClassFactory.class);
    private final ParameterProvider parameterProvider;

    public SimpleClassFactory() {
        this.parameterProvider = new ParameterProvider(){

            @Override
            public <T> Optional<T> get(Class<T> x) {
                return Optional.empty();
            }
        };
    }

    public SimpleClassFactory(ParameterProvider parameterProvider) {
        this.parameterProvider = parameterProvider;
    }

    @Override
    public <T> Optional<T> instantiateClass(Class<? extends T> discoveredType) {
        ArrayList possibleConstructors = Lists.newArrayList((Object[])discoveredType.getConstructors());
        possibleConstructors.sort(Comparator.comparing(x -> x.getParameterTypes().length).reversed());
        for (Constructor constructor : possibleConstructors) {
            boolean populatedAllParams = true;
            Object[] param = new Object[constructor.getParameterTypes().length];
            for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
                if (constructor.getParameterTypes()[i].equals(Optional.class)) {
                    Optional<Type> optionalType = GenericsUtil.getTypeParameterBinding(constructor.getGenericParameterTypes()[i], 0);
                    if (!optionalType.isPresent()) {
                        populatedAllParams = false;
                        break;
                    }
                    Class<?> paramClass = GenericsUtil.getClassOfType(optionalType.get());
                    param[i] = this.parameterProvider.get(paramClass);
                    continue;
                }
                Optional<?> value = this.parameterProvider.get(constructor.getParameterTypes()[i]);
                if (value.isPresent()) {
                    param[i] = value.get();
                    continue;
                }
                populatedAllParams = false;
                break;
            }
            if (!populatedAllParams) continue;
            try {
                return Optional.of(discoveredType.cast(constructor.newInstance(param)));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                logger.error("Failed to instantiate class: {}", discoveredType, (Object)e);
                return Optional.empty();
            }
        }
        logger.error("Type '{}' missing usable constructor", discoveredType);
        return Optional.empty();
    }
}

