/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.desktop;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Graphics;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.SplashScreen;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.SolFileReader;
import org.destinationsol.game.DebugOptions;
import org.destinationsol.modules.ModuleManager;
import org.destinationsol.ui.ResizeSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.crashreporter.CrashReporter;

public final class SolDesktop {
    private static Logger logger = LoggerFactory.getLogger(SolDesktop.class);
    private static boolean initFinished;
    private static ModuleManager moduleManager;
    private static final String NO_CRASH_REPORT = "-noCrashReport";
    private static final String NO_SPLASH_SCREEN = "-noSplash";
    private static final Color LOGO_COLOUR;

    private SolDesktop() {
    }

    public static void main(String[] argv) {
        boolean useSplash;
        SplashScreen splash = null;
        try {
            splash = SplashScreen.getSplashScreen();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean bl = useSplash = splash != null && Stream.of(argv).noneMatch(s -> s.equals(NO_SPLASH_SCREEN));
        if (useSplash) {
            Graphics2D splashScreenGraphics = splash.createGraphics();
            Rectangle splashBounds = splash.getBounds();
            splashScreenGraphics.setColor(LOGO_COLOUR);
            splashScreenGraphics.setPaintMode();
            splashScreenGraphics.fillRect(0, 0, splashBounds.width, splashBounds.height);
            splash.update();
        }
        Lwjgl3ApplicationConfiguration applicationConfig = new Lwjgl3ApplicationConfiguration();
        SolDesktop.handleDevBuild(applicationConfig);
        MyReader reader = new MyReader();
        DebugOptions.read(reader);
        GameOptions options = new GameOptions(false, reader);
        SolDesktop.setScreenDimensions(applicationConfig, options);
        applicationConfig.setTitle("Destination Sol");
        if (DebugOptions.DEV_ROOT_PATH == null) {
            applicationConfig.setWindowIcon(Files.FileType.Internal, new String[]{"icon.png"});
        } else {
            applicationConfig.setWindowIcon(Files.FileType.Absolute, new String[]{DebugOptions.DEV_ROOT_PATH + "/icon.png"});
        }
        SolDesktop.handleCrashReporting(argv);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    moduleManager = new ModuleManager();
                    moduleManager.init();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                initFinished = true;
            }
        }).start();
        while (!initFinished) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (useSplash) {
            splash.close();
        }
        SolApplication application = new SolApplication(moduleManager, 100.0f);
        SolApplication.addResizeSubscriber(new FullScreenWindowPositionAdjustment(!options.fullscreen));
        new Lwjgl3Application((ApplicationListener)application, applicationConfig);
    }

    private static void handleDevBuild(Lwjgl3ApplicationConfiguration applicationConfig) {
        boolean devBuild = Files.exists(Paths.get("devBuild", new String[0]), new LinkOption[0]);
        if (devBuild) {
            DebugOptions.DEV_ROOT_PATH = "engine/src/main/resources/";
            applicationConfig.useVsync(false);
            applicationConfig.setIdleFPS(10);
        }
    }

    private static void handleCrashReporting(String[] argv) {
        if (Stream.of(argv).noneMatch(s -> s.equals(NO_CRASH_REPORT))) {
            Thread.setDefaultUncaughtExceptionHandler((thread, ex) -> {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                ex.printStackTrace(printWriter);
                String exceptionString = stringWriter.getBuffer().toString();
                logger.error("This exception was not caught:", ex);
                String fileName = "crash-" + new SimpleDateFormat("yyyy-dd-MM_HH-mm-ss").format(new Date()) + ".log";
                List<String> lines = Collections.singletonList(exceptionString);
                Path logPath = Paths.get(new MyReader().create(fileName, lines), new String[0]).getParent();
                new Thread(() -> CrashReporter.report((Throwable)ex, (Path)logPath)).start();
            });
        }
    }

    private static void setScreenDimensions(Lwjgl3ApplicationConfiguration applicationConfig, GameOptions options) {
        if (DebugOptions.EMULATE_MOBILE) {
            applicationConfig.setWindowedMode(640, 480);
        } else if (options.fullscreen) {
            Graphics.DisplayMode mode = null;
            for (Graphics.DisplayMode displayMode : Lwjgl3ApplicationConfiguration.getDisplayModes()) {
                if (displayMode.width != options.x || displayMode.height != options.y) continue;
                mode = displayMode;
            }
            if (mode != null) {
                applicationConfig.setFullscreenMode(mode);
            } else {
                logger.warn("The resolution {}x{} is not supported in fullscreen mode!", (Object)options.x, (Object)options.y);
            }
        } else {
            applicationConfig.setWindowedMode(options.x, options.y);
        }
    }

    static {
        LOGO_COLOUR = Color.LIGHT_GRAY;
    }

    private static class MyReader
    implements SolFileReader {
        private MyReader() {
        }

        @Override
        public String create(String fileName, List<String> lines) {
            String path = "";
            if (DebugOptions.DEV_ROOT_PATH != null) {
                path = DebugOptions.DEV_ROOT_PATH;
            }
            path = path + fileName;
            Path file = Paths.get(path, new String[0]);
            try {
                Files.write(file, lines, Charset.forName("UTF-8"), new OpenOption[0]);
            }
            catch (IOException e) {
                logger.error("Failed to write to file", (Throwable)e);
            }
            return file.toAbsolutePath().toString();
        }

        @Override
        public List<String> read(String fileName) {
            String path = "";
            if (DebugOptions.DEV_ROOT_PATH != null) {
                path = DebugOptions.DEV_ROOT_PATH;
            }
            path = path + fileName;
            ArrayList<String> lines = new ArrayList<String>();
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(path));
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
                br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return lines;
        }
    }

    private static final class FullScreenWindowPositionAdjustment
    implements ResizeSubscriber {
        private boolean lastFullScreenState;

        public FullScreenWindowPositionAdjustment(boolean lastFullScreenState) {
            this.lastFullScreenState = lastFullScreenState;
        }

        @Override
        public void resize() {
            if (this.lastFullScreenState && !Gdx.graphics.isFullscreen()) {
                Graphics.DisplayMode mode = Gdx.graphics.getDisplayMode();
                ((Lwjgl3Graphics)Gdx.graphics).getWindow().setPosition(mode.width / 4, mode.height / 4);
            }
            this.lastFullScreenState = Gdx.graphics.isFullscreen();
        }
    }
}

