/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.ApplicationLogger;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationLogger;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Clipboard;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Cursor;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3FileHandle;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Files;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3NativesLoader;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Net;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Preferences;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Window;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3WindowConfiguration;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALAudio;
import com.badlogic.gdx.backends.lwjgl3.audio.mock.MockAudio;
import com.badlogic.gdx.graphics.glutils.GLVersion;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import java.io.File;
import java.io.PrintStream;
import java.nio.IntBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.AMDDebugOutput;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLUtil;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.system.Callback;

public class Lwjgl3Application
implements Application {
    private final Lwjgl3ApplicationConfiguration config;
    private final Array<Lwjgl3Window> windows = new Array();
    private volatile Lwjgl3Window currentWindow;
    private Audio audio;
    private final Files files;
    private final Net net;
    private final ObjectMap<String, Preferences> preferences = new ObjectMap();
    private final Lwjgl3Clipboard clipboard;
    private int logLevel = 2;
    private ApplicationLogger applicationLogger;
    private volatile boolean running = true;
    private final Array<Runnable> runnables = new Array();
    private final Array<Runnable> executedRunnables = new Array();
    private final Array<LifecycleListener> lifecycleListeners = new Array();
    private static GLFWErrorCallback errorCallback;
    private static GLVersion glVersion;
    private static Callback glDebugCallback;

    static void initializeGlfw() {
        if (errorCallback == null) {
            Lwjgl3NativesLoader.load();
            errorCallback = GLFWErrorCallback.createPrint((PrintStream)System.err);
            GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)errorCallback);
            GLFW.glfwInitHint((int)327681, (int)0);
            if (!GLFW.glfwInit()) {
                throw new GdxRuntimeException("Unable to initialize GLFW");
            }
        }
    }

    public Lwjgl3Application(ApplicationListener listener, Lwjgl3ApplicationConfiguration config) {
        Lwjgl3Application.initializeGlfw();
        this.setApplicationLogger(new Lwjgl3ApplicationLogger());
        this.config = Lwjgl3ApplicationConfiguration.copy(config);
        if (this.config.title == null) {
            this.config.title = listener.getClass().getSimpleName();
        }
        Gdx.app = this;
        if (!config.disableAudio) {
            try {
                this.audio = Gdx.audio = new OpenALAudio(config.audioDeviceSimultaneousSources, config.audioDeviceBufferCount, config.audioDeviceBufferSize);
            }
            catch (Throwable t) {
                this.log("Lwjgl3Application", "Couldn't initialize audio, disabling audio", t);
                this.audio = Gdx.audio = new MockAudio();
            }
        } else {
            this.audio = Gdx.audio = new MockAudio();
        }
        this.files = Gdx.files = new Lwjgl3Files();
        this.net = Gdx.net = new Lwjgl3Net();
        this.clipboard = new Lwjgl3Clipboard();
        Lwjgl3Window window = this.createWindow(config, listener, 0L);
        this.windows.add((Object)window);
        try {
            this.loop();
            this.cleanupWindows();
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new GdxRuntimeException(t);
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loop() {
        Array closedWindows = new Array();
        while (this.running && this.windows.size > 0) {
            boolean shouldRequestRendering;
            if (this.audio instanceof OpenALAudio) {
                ((OpenALAudio)this.audio).update();
            }
            boolean haveWindowsRendered = false;
            closedWindows.clear();
            for (Lwjgl3Window window : this.windows) {
                window.makeCurrent();
                this.currentWindow = window;
                Array<LifecycleListener> array = this.lifecycleListeners;
                synchronized (array) {
                    haveWindowsRendered |= window.update();
                }
                if (!window.shouldClose()) continue;
                closedWindows.add((Object)window);
            }
            GLFW.glfwPollEvents();
            Array<Runnable> array = this.runnables;
            synchronized (array) {
                shouldRequestRendering = this.runnables.size > 0;
                this.executedRunnables.clear();
                this.executedRunnables.addAll(this.runnables);
                this.runnables.clear();
            }
            for (Runnable runnable : this.executedRunnables) {
                runnable.run();
            }
            if (shouldRequestRendering) {
                for (Lwjgl3Window window : this.windows) {
                    if (window.getGraphics().isContinuousRendering()) continue;
                    window.requestRendering();
                }
            }
            for (Lwjgl3Window closedWindow : closedWindows) {
                if (this.windows.size == 1) {
                    for (int i = this.lifecycleListeners.size - 1; i >= 0; --i) {
                        LifecycleListener l = (LifecycleListener)this.lifecycleListeners.get(i);
                        l.pause();
                        l.dispose();
                    }
                    this.lifecycleListeners.clear();
                }
                closedWindow.dispose();
                this.windows.removeValue((Object)closedWindow, false);
            }
            if (haveWindowsRendered) continue;
            try {
                Thread.sleep(1000 / this.config.idleFPS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupWindows() {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
                lifecycleListener.pause();
                lifecycleListener.dispose();
            }
        }
        for (Lwjgl3Window window : this.windows) {
            window.dispose();
        }
        this.windows.clear();
    }

    private void cleanup() {
        Lwjgl3Cursor.disposeSystemCursors();
        if (this.audio instanceof OpenALAudio) {
            ((OpenALAudio)this.audio).dispose();
        }
        errorCallback.free();
        errorCallback = null;
        if (glDebugCallback != null) {
            glDebugCallback.free();
            glDebugCallback = null;
        }
        GLFW.glfwTerminate();
    }

    public ApplicationListener getApplicationListener() {
        return this.currentWindow.getListener();
    }

    public Graphics getGraphics() {
        return this.currentWindow.getGraphics();
    }

    public Audio getAudio() {
        return this.audio;
    }

    public Input getInput() {
        return this.currentWindow.getInput();
    }

    public Files getFiles() {
        return this.files;
    }

    public Net getNet() {
        return this.net;
    }

    public void debug(String tag, String message) {
        if (this.logLevel >= 3) {
            this.getApplicationLogger().debug(tag, message);
        }
    }

    public void debug(String tag, String message, Throwable exception) {
        if (this.logLevel >= 3) {
            this.getApplicationLogger().debug(tag, message, exception);
        }
    }

    public void log(String tag, String message) {
        if (this.logLevel >= 2) {
            this.getApplicationLogger().log(tag, message);
        }
    }

    public void log(String tag, String message, Throwable exception) {
        if (this.logLevel >= 2) {
            this.getApplicationLogger().log(tag, message, exception);
        }
    }

    public void error(String tag, String message) {
        if (this.logLevel >= 1) {
            this.getApplicationLogger().error(tag, message);
        }
    }

    public void error(String tag, String message, Throwable exception) {
        if (this.logLevel >= 1) {
            this.getApplicationLogger().error(tag, message, exception);
        }
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setApplicationLogger(ApplicationLogger applicationLogger) {
        this.applicationLogger = applicationLogger;
    }

    public ApplicationLogger getApplicationLogger() {
        return this.applicationLogger;
    }

    public Application.ApplicationType getType() {
        return Application.ApplicationType.Desktop;
    }

    public int getVersion() {
        return 0;
    }

    public long getJavaHeap() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public long getNativeHeap() {
        return this.getJavaHeap();
    }

    public Preferences getPreferences(String name) {
        if (this.preferences.containsKey((Object)name)) {
            return (Preferences)this.preferences.get((Object)name);
        }
        Lwjgl3Preferences prefs = new Lwjgl3Preferences(new Lwjgl3FileHandle(new File(this.config.preferencesDirectory, name), this.config.preferencesFileType));
        this.preferences.put((Object)name, (Object)prefs);
        return prefs;
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRunnable(Runnable runnable) {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.runnables.add((Object)runnable);
        }
    }

    public void exit() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.removeValue((Object)listener, true);
        }
    }

    public Lwjgl3Window newWindow(ApplicationListener listener, Lwjgl3WindowConfiguration config) {
        Lwjgl3ApplicationConfiguration appConfig = Lwjgl3ApplicationConfiguration.copy(this.config);
        appConfig.setWindowConfiguration(config);
        return this.createWindow(appConfig, listener, ((Lwjgl3Window)this.windows.get(0)).getWindowHandle());
    }

    private Lwjgl3Window createWindow(Lwjgl3ApplicationConfiguration config, ApplicationListener listener, long sharedContext) {
        Lwjgl3Window window = new Lwjgl3Window(listener, config);
        if (sharedContext == 0L) {
            this.createWindow(window, config, sharedContext);
        } else {
            this.postRunnable(() -> {
                this.createWindow(window, config, sharedContext);
                this.windows.add((Object)window);
            });
        }
        return window;
    }

    private void createWindow(Lwjgl3Window window, Lwjgl3ApplicationConfiguration config, long sharedContext) {
        long windowHandle = Lwjgl3Application.createGlfwWindow(config, sharedContext);
        window.create(windowHandle);
        window.setVisible(config.initialVisible);
        for (int i = 0; i < 2; ++i) {
            GL11.glClearColor((float)config.initialBackgroundColor.r, (float)config.initialBackgroundColor.g, (float)config.initialBackgroundColor.b, (float)config.initialBackgroundColor.a);
            GL11.glClear((int)16384);
            GLFW.glfwSwapBuffers((long)windowHandle);
        }
    }

    static long createGlfwWindow(Lwjgl3ApplicationConfiguration config, long sharedContextWindow) {
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)131075, (int)(config.windowResizable ? 1 : 0));
        GLFW.glfwWindowHint((int)131080, (int)(config.windowMaximized ? 1 : 0));
        if (sharedContextWindow == 0L) {
            GLFW.glfwWindowHint((int)135169, (int)config.r);
            GLFW.glfwWindowHint((int)135170, (int)config.g);
            GLFW.glfwWindowHint((int)135171, (int)config.b);
            GLFW.glfwWindowHint((int)135172, (int)config.a);
            GLFW.glfwWindowHint((int)135174, (int)config.stencil);
            GLFW.glfwWindowHint((int)135173, (int)config.depth);
            GLFW.glfwWindowHint((int)135181, (int)config.samples);
        }
        if (config.useGL30) {
            GLFW.glfwWindowHint((int)139266, (int)config.gles30ContextMajorVersion);
            GLFW.glfwWindowHint((int)139267, (int)config.gles30ContextMinorVersion);
            if (SharedLibraryLoader.isMac) {
                GLFW.glfwWindowHint((int)139270, (int)1);
                GLFW.glfwWindowHint((int)139272, (int)204801);
            }
        }
        if (config.debug) {
            GLFW.glfwWindowHint((int)139271, (int)1);
        }
        long windowHandle = 0L;
        if (config.fullscreenMode != null) {
            windowHandle = GLFW.glfwCreateWindow((int)config.fullscreenMode.width, (int)config.fullscreenMode.height, (CharSequence)config.title, (long)config.fullscreenMode.getMonitor(), (long)sharedContextWindow);
        } else {
            GLFW.glfwWindowHint((int)131077, (int)(config.windowDecorated ? 1 : 0));
            windowHandle = GLFW.glfwCreateWindow((int)config.windowWidth, (int)config.windowHeight, (CharSequence)config.title, (long)0L, (long)sharedContextWindow);
        }
        if (windowHandle == 0L) {
            throw new GdxRuntimeException("Couldn't create window");
        }
        Lwjgl3Window.setSizeLimits(windowHandle, config.windowMinWidth, config.windowMinHeight, config.windowMaxWidth, config.windowMaxHeight);
        if (config.fullscreenMode == null && !config.windowMaximized) {
            if (config.windowX == -1 && config.windowY == -1) {
                int windowWidth = Math.max(config.windowWidth, config.windowMinWidth);
                int windowHeight = Math.max(config.windowHeight, config.windowMinHeight);
                if (config.windowMaxWidth > -1) {
                    windowWidth = Math.min(windowWidth, config.windowMaxWidth);
                }
                if (config.windowMaxHeight > -1) {
                    windowHeight = Math.min(windowHeight, config.windowMaxHeight);
                }
                GLFWVidMode vidMode = GLFW.glfwGetVideoMode((long)GLFW.glfwGetPrimaryMonitor());
                GLFW.glfwSetWindowPos((long)windowHandle, (int)(vidMode.width() / 2 - windowWidth / 2), (int)(vidMode.height() / 2 - windowHeight / 2));
            } else {
                GLFW.glfwSetWindowPos((long)windowHandle, (int)config.windowX, (int)config.windowY);
            }
        }
        if (config.windowIconPaths != null) {
            Lwjgl3Window.setIcon(windowHandle, config.windowIconPaths, config.windowIconFileType);
        }
        GLFW.glfwMakeContextCurrent((long)windowHandle);
        GLFW.glfwSwapInterval((int)(config.vSyncEnabled ? 1 : 0));
        GL.createCapabilities();
        Lwjgl3Application.initiateGL();
        if (!glVersion.isVersionEqualToOrHigher(2, 0)) {
            throw new GdxRuntimeException("OpenGL 2.0 or higher with the FBO extension is required. OpenGL version: " + GL11.glGetString((int)7938) + "\n" + glVersion.getDebugVersionString());
        }
        if (!Lwjgl3Application.supportsFBO()) {
            throw new GdxRuntimeException("OpenGL 2.0 or higher with the FBO extension is required. OpenGL version: " + GL11.glGetString((int)7938) + ", FBO extension: false\n" + glVersion.getDebugVersionString());
        }
        if (config.debug) {
            glDebugCallback = GLUtil.setupDebugMessageCallback((PrintStream)config.debugStream);
            Lwjgl3Application.setGLDebugMessageControl(GLDebugMessageSeverity.NOTIFICATION, false);
        }
        return windowHandle;
    }

    private static void initiateGL() {
        String versionString = GL11.glGetString((int)7938);
        String vendorString = GL11.glGetString((int)7936);
        String rendererString = GL11.glGetString((int)7937);
        glVersion = new GLVersion(Application.ApplicationType.Desktop, versionString, vendorString, rendererString);
    }

    private static boolean supportsFBO() {
        return glVersion.isVersionEqualToOrHigher(3, 0) || GLFW.glfwExtensionSupported((CharSequence)"GL_EXT_framebuffer_object") || GLFW.glfwExtensionSupported((CharSequence)"GL_ARB_framebuffer_object");
    }

    public static boolean setGLDebugMessageControl(GLDebugMessageSeverity severity, boolean enabled) {
        GLCapabilities caps = GL.getCapabilities();
        int GL_DONT_CARE = 4352;
        if (caps.OpenGL43) {
            GL43.glDebugMessageControl((int)4352, (int)4352, (int)severity.gl43, (IntBuffer)null, (boolean)enabled);
            return true;
        }
        if (caps.GL_KHR_debug) {
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)severity.khr, (IntBuffer)null, (boolean)enabled);
            return true;
        }
        if (caps.GL_ARB_debug_output && severity.arb != -1) {
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)severity.arb, (IntBuffer)null, (boolean)enabled);
            return true;
        }
        if (caps.GL_AMD_debug_output && severity.amd != -1) {
            AMDDebugOutput.glDebugMessageEnableAMD((int)4352, (int)severity.amd, (IntBuffer)null, (boolean)enabled);
            return true;
        }
        return false;
    }

    public static enum GLDebugMessageSeverity {
        HIGH(37190, 37190, 37190, 37190),
        MEDIUM(37191, 37191, 37191, 37191),
        LOW(37192, 37192, 37192, 37192),
        NOTIFICATION(33387, 33387, -1, -1);

        final int gl43;
        final int khr;
        final int arb;
        final int amd;

        private GLDebugMessageSeverity(int gl43, int khr, int arb, int amd) {
            this.gl43 = gl43;
            this.khr = khr;
            this.arb = arb;
            this.amd = amd;
        }
    }
}

