/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.javafx.font.CharToGlyphMapper;
import com.sun.javafx.font.FontFactory;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.webkit.prism.TextUtilities;
import com.sun.prism.GraphicsPipeline;
import com.sun.webkit.graphics.WCFont;
import com.sun.webkit.graphics.WCTextRun;
import com.sun.webkit.graphics.WCTextRunImpl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

final class WCFontImpl
extends WCFont {
    private static final Logger log = Logger.getLogger(WCFontImpl.class.getName());
    private static final HashMap<String, String> FONT_MAP = new HashMap();
    private final PGFont font;
    private FontStrike strike;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WCFont getFont(String name, boolean bold, boolean italic, float size) {
        FontFactory factory = GraphicsPipeline.getPipeline().getFontFactory();
        HashMap<String, String> hashMap = FONT_MAP;
        synchronized (hashMap) {
            if (FONT_MAP.isEmpty()) {
                FONT_MAP.put("serif", "Serif");
                FONT_MAP.put("dialog", "SansSerif");
                FONT_MAP.put("helvetica", "SansSerif");
                FONT_MAP.put("sansserif", "SansSerif");
                FONT_MAP.put("sans-serif", "SansSerif");
                FONT_MAP.put("monospace", "Monospaced");
                FONT_MAP.put("monospaced", "Monospaced");
                FONT_MAP.put("times", "Times New Roman");
                FONT_MAP.put("courier", "Courier New");
                for (String family : factory.getFontFamilyNames()) {
                    FONT_MAP.put(family.toLowerCase(), family);
                }
            }
        }
        String family = FONT_MAP.get(name.toLowerCase());
        if (log.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder("WCFontImpl.get(");
            sb.append(name).append(", ").append(size);
            if (bold) {
                sb.append(", bold");
            }
            if (italic) {
                sb.append(", italic");
            }
            log.fine(sb.append(") = ").append(family).toString());
        }
        return family != null ? new WCFontImpl(factory.createFont(family, bold, italic, size)) : null;
    }

    WCFontImpl(PGFont font) {
        this.font = font;
    }

    @Override
    public WCFont deriveFont(float size) {
        FontFactory factory = GraphicsPipeline.getPipeline().getFontFactory();
        return new WCFontImpl(factory.deriveFont(this.font, this.font.getFontResource().isBold(), this.font.getFontResource().isItalic(), size));
    }

    private FontStrike getFontStrike() {
        if (this.strike == null) {
            this.strike = this.font.getStrike(BaseTransform.IDENTITY_TRANSFORM, 1);
        }
        return this.strike;
    }

    @Override
    public double getGlyphWidth(int glyph) {
        return this.getFontStrike().getFontResource().getAdvance(glyph, this.font.getSize());
    }

    @Override
    public float[] getGlyphBoundingBox(int glyph) {
        float[] bb = new float[4];
        bb = this.getFontStrike().getFontResource().getGlyphBoundingBox(glyph, this.font.getSize(), bb);
        return new float[]{bb[0], -bb[3], bb[2], bb[3] - bb[1]};
    }

    @Override
    public float getXHeight() {
        return this.getFontStrike().getMetrics().getXHeight();
    }

    @Override
    public int[] getGlyphCodes(char[] chars) {
        int[] glyphs = new int[chars.length];
        CharToGlyphMapper mapper = this.getFontStrike().getFontResource().getGlyphMapper();
        mapper.charsToGlyphs(chars.length, chars, glyphs);
        return glyphs;
    }

    @Override
    public float getAscent() {
        float res = -this.getFontStrike().getMetrics().getAscent();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "getAscent({0}, {1}) = {2}", new Object[]{this.font.getName(), Float.valueOf(this.font.getSize()), Float.valueOf(res)});
        }
        return res;
    }

    @Override
    public float getDescent() {
        float res = this.getFontStrike().getMetrics().getDescent();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "getDescent({0}, {1}) = {2}", new Object[]{this.font.getName(), Float.valueOf(this.font.getSize()), Float.valueOf(res)});
        }
        return res;
    }

    @Override
    public float getLineSpacing() {
        float res = this.getFontStrike().getMetrics().getLineHeight();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "getLineSpacing({0}, {1}) = {2}", new Object[]{this.font.getName(), Float.valueOf(this.font.getSize()), Float.valueOf(res)});
        }
        return res;
    }

    @Override
    public float getLineGap() {
        float res = this.getFontStrike().getMetrics().getLineGap();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "getLineGap({0}, {1}) = {2}", new Object[]{this.font.getName(), Float.valueOf(this.font.getSize()), Float.valueOf(res)});
        }
        return res;
    }

    @Override
    public boolean hasUniformLineMetrics() {
        return false;
    }

    @Override
    public Object getPlatformFont() {
        return this.font;
    }

    @Override
    public float getCapHeight() {
        return this.getFontStrike().getMetrics().getCapHeight();
    }

    @Override
    public WCTextRun[] getTextRuns(String str) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("str='%s' length=%d", str, str.length()));
        }
        TextLayout layout = TextUtilities.createLayout(str, this.getPlatformFont());
        return (WCTextRun[])Arrays.stream(layout.getRuns()).map(WCTextRunImpl::new).toArray(WCTextRunImpl[]::new);
    }
}

