/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.scene.layout.region.BorderImageSlices;
import javafx.beans.NamedArg;
import javafx.geometry.Insets;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderRepeat;
import javafx.scene.layout.BorderWidths;

public class BorderImage {
    final Image image;
    final BorderRepeat repeatX;
    final BorderRepeat repeatY;
    final BorderWidths widths;
    final BorderWidths slices;
    final boolean filled;
    final Insets insets;
    final Insets innerEdge;
    final Insets outerEdge;
    private final int hash;

    public final Image getImage() {
        return this.image;
    }

    public final BorderRepeat getRepeatX() {
        return this.repeatX;
    }

    public final BorderRepeat getRepeatY() {
        return this.repeatY;
    }

    public final BorderWidths getWidths() {
        return this.widths;
    }

    public final BorderWidths getSlices() {
        return this.slices;
    }

    public final boolean isFilled() {
        return this.filled;
    }

    public final Insets getInsets() {
        return this.insets;
    }

    public BorderImage(@NamedArg(value="image") Image image, @NamedArg(value="widths") BorderWidths widths, @NamedArg(value="insets") Insets insets, @NamedArg(value="slices") BorderWidths slices, @NamedArg(value="filled") boolean filled, @NamedArg(value="repeatX") BorderRepeat repeatX, @NamedArg(value="repeatY") BorderRepeat repeatY) {
        if (image == null) {
            throw new NullPointerException("Image cannot be null");
        }
        this.image = image;
        this.widths = widths == null ? BorderWidths.DEFAULT : widths;
        this.insets = insets == null ? Insets.EMPTY : insets;
        this.slices = slices == null ? BorderImageSlices.DEFAULT.widths : slices;
        this.filled = filled;
        this.repeatX = repeatX == null ? BorderRepeat.STRETCH : repeatX;
        this.repeatY = repeatY == null ? this.repeatX : repeatY;
        this.outerEdge = new Insets(Math.max(0.0, -this.insets.getTop()), Math.max(0.0, -this.insets.getRight()), Math.max(0.0, -this.insets.getBottom()), Math.max(0.0, -this.insets.getLeft()));
        this.innerEdge = new Insets(this.insets.getTop() + this.widths.getTop(), this.insets.getRight() + this.widths.getRight(), this.insets.getBottom() + this.widths.getBottom(), this.insets.getLeft() + this.widths.getLeft());
        int result = this.image.hashCode();
        result = 31 * result + this.widths.hashCode();
        result = 31 * result + this.slices.hashCode();
        result = 31 * result + this.repeatX.hashCode();
        result = 31 * result + this.repeatY.hashCode();
        this.hash = result = 31 * result + (this.filled ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BorderImage that = (BorderImage)o;
        if (this.hash != that.hash) {
            return false;
        }
        if (this.filled != that.filled) {
            return false;
        }
        if (!this.image.equals(that.image)) {
            return false;
        }
        if (this.repeatX != that.repeatX) {
            return false;
        }
        if (this.repeatY != that.repeatY) {
            return false;
        }
        if (!this.slices.equals(that.slices)) {
            return false;
        }
        return this.widths.equals(that.widths);
    }

    public int hashCode() {
        return this.hash;
    }
}

