/*
 * Decompiled with CFR 0.152.
 */
package org.jpaste.pastebin;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jpaste.exceptions.PasteException;
import org.jpaste.pastebin.PasteExpireDate;
import org.jpaste.pastebin.PastebinLink;
import org.jpaste.pastebin.PastebinPaste;
import org.jpaste.pastebin.exceptions.ParseException;
import org.jpaste.utils.web.Post;
import org.jpaste.utils.web.Web;
import org.jpaste.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Pastebin {
    public static final String API_POST_LINK = "http://pastebin.com/api/api_post.php";
    public static final String API_LOGIN_LINK = "http://pastebin.com/api/api_login.php";

    public static String getContents(String pasteKey) {
        return PastebinLink.getContents(pasteKey);
    }

    public static URL pastePaste(String developerKey, String contents) throws PasteException {
        return Pastebin.pastePaste(developerKey, contents, null);
    }

    public static URL pastePaste(String developerKey, String contents, String title) throws PasteException {
        return Pastebin.newPaste(developerKey, contents, title).paste().getLink();
    }

    public static PastebinPaste newPaste(String developerKey, String contents, String title) {
        PastebinPaste paste = new PastebinPaste(developerKey, contents);
        paste.setPasteTitle(title);
        return paste;
    }

    public static PastebinPaste newPaste(String developerKey, String contents) {
        return Pastebin.newPaste(developerKey, contents, null);
    }

    public static PastebinLink[] getTrending(String developerKey) throws ParseException {
        if (developerKey == null || developerKey.isEmpty()) {
            throw new IllegalArgumentException("Developer key can't be null or empty.");
        }
        Post post = new Post();
        post.put("api_dev_key", developerKey);
        post.put("api_option", "trends");
        String response = Web.getContents(API_POST_LINK, post);
        if (response.startsWith("<paste>")) {
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                response = "<dummy>" + response + "</dummy>";
                Document doc = dBuilder.parse(new InputSource(new ByteArrayInputStream(response.getBytes("utf-8"))));
                doc.getDocumentElement().normalize();
                NodeList nodes = doc.getElementsByTagName("paste");
                ArrayList<PastebinLink> pastes = new ArrayList<PastebinLink>(nodes.getLength());
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    String pasteFormat = XMLUtils.getText(element, "paste_format_short");
                    String title = XMLUtils.getText(element, "paste_title");
                    int visibility = Integer.parseInt(XMLUtils.getText(element, "paste_private"));
                    int hits = Integer.parseInt(XMLUtils.getText(element, "paste_hits"));
                    long expireDate = Long.parseLong(XMLUtils.getText(element, "paste_expire_date"));
                    long pasteDate = Long.parseLong(XMLUtils.getText(element, "paste_date"));
                    URL pasteURL = new URL(XMLUtils.getText(element, "paste_url"));
                    PastebinPaste paste = new PastebinPaste();
                    paste.setPasteFormat(pasteFormat);
                    paste.setPasteTitle(title);
                    paste.setVisibility(visibility);
                    paste.setPasteExpireDate(expireDate == 0L ? PasteExpireDate.NEVER : PasteExpireDate.getExpireDate((int)(expireDate - pasteDate)));
                    PastebinLink pastebinLink = new PastebinLink(paste, pasteURL, new Date(pasteDate * 1000L));
                    pastebinLink.setHits(hits);
                    pastes.add(pastebinLink);
                }
                return pastes.toArray(new PastebinLink[pastes.size()]);
            }
            catch (Exception e) {
                throw new ParseException("Failed to parse pastes: " + e.getMessage());
            }
        }
        throw new ParseException("Failed to parse pastes: " + response);
    }
}

