/*
 * Decompiled with CFR 0.152.
 */
package org.jpaste.pastebin;

import java.net.MalformedURLException;
import java.net.URL;
import org.jpaste.AbstractPaste;
import org.jpaste.exceptions.PasteException;
import org.jpaste.pastebin.PasteExpireDate;
import org.jpaste.pastebin.PastebinLink;
import org.jpaste.pastebin.account.PastebinAccount;
import org.jpaste.utils.web.Post;
import org.jpaste.utils.web.Web;

public class PastebinPaste
extends AbstractPaste<PastebinLink> {
    public static final int VISIBILITY_PUBLIC = 0;
    public static final int VISIBILITY_UNLISTED = 1;
    public static final int VISIBILITY_PRIVATE = 2;
    private String developerKey;
    private PastebinAccount account;
    private String pasteTitle;
    private String pasteFormat;
    private PasteExpireDate expireDate;
    private int visibility;

    public PastebinPaste() {
        this(null, null, null);
    }

    public PastebinPaste(String contents) {
        this(null, contents, null);
    }

    public PastebinPaste(PastebinAccount account) {
        this(account.getDeveloperKey(), null, account);
    }

    public PastebinPaste(String developerKey, String contents) {
        this(developerKey, contents, null);
    }

    public PastebinPaste(String developerKey, String contents, PastebinAccount account) {
        super(contents);
        this.developerKey = developerKey;
        this.account = account;
    }

    public void setAccount(PastebinAccount account) {
        this.account = account;
    }

    public PastebinAccount getAccount() {
        return this.account;
    }

    public void setDeveloperKey(String developerKey) {
        if (developerKey == null || developerKey.isEmpty()) {
            throw new IllegalArgumentException("Developer key can not be null or empty.");
        }
        this.developerKey = developerKey;
    }

    public void setPasteExpireDate(PasteExpireDate date) {
        this.expireDate = date;
    }

    public String getDeveloperKey() {
        return this.developerKey;
    }

    public void setPasteTitle(String title) {
        this.pasteTitle = title;
    }

    public String getPasteTitle() {
        return this.pasteTitle;
    }

    public PasteExpireDate getPasteExpireDate() {
        return this.expireDate;
    }

    public void setPasteFormat(String format) {
        this.pasteFormat = format;
    }

    public String getPasteFormat() {
        return this.pasteFormat;
    }

    public void setVisibility(int visibility) {
        if (visibility < 0 || visibility > 2) {
            throw new IllegalArgumentException("Unknown visibility: " + visibility);
        }
        this.visibility = visibility;
    }

    public int getVisibility() {
        return this.visibility;
    }

    @Override
    public PastebinLink paste() throws PasteException {
        if (this.getContents() == null || this.getContents().isEmpty()) {
            throw new IllegalStateException("Paste can not be null or empty.");
        }
        if (this.getDeveloperKey() == null || this.getDeveloperKey().isEmpty()) {
            throw new IllegalStateException("Developer key is missing.");
        }
        Post post = new Post();
        post.put("api_dev_key", this.getDeveloperKey());
        post.put("api_option", "paste");
        post.put("api_paste_code", this.getContents());
        if (this.account != null && this.account.getUserSessionId() != null) {
            post.put("api_user_key", this.account.getUserSessionId());
        }
        if (this.pasteTitle != null) {
            post.put("api_paste_name", this.getPasteTitle());
        }
        if (this.pasteFormat != null) {
            post.put("api_paste_format", this.getPasteFormat());
        }
        post.put("api_paste_private", Integer.toString(this.getVisibility()));
        if (this.expireDate != null) {
            post.put("api_paste_expire_date", this.expireDate.getValue());
        }
        try {
            String pageResponse = Web.getContents("http://pastebin.com/api/api_post.php", post);
            if (pageResponse.startsWith("http")) {
                PastebinLink result = new PastebinLink(this, new URL(pageResponse));
                return result;
            }
            throw new PasteException("Failed to generate paste: " + pageResponse);
        }
        catch (MalformedURLException e) {
            throw new PasteException("Failed to generate paste: " + e);
        }
    }
}

