/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.nominatim;

import fr.dudie.nominatim.client.JsonNominatimClient;
import fr.dudie.nominatim.client.NominatimOptions;
import fr.dudie.nominatim.model.Address;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.mapton.api.MLatLon;
import org.openide.util.Exceptions;

public class Nominatim {
    private static final Logger LOGGER = Logger.getLogger(Nominatim.class.getName());

    public static Nominatim getInstance() {
        return Holder.INSTANCE;
    }

    public static void main(String[] args) throws IOException {
        Nominatim nominatim = Nominatim.getInstance();
        System.out.println(ToStringBuilder.reflectionToString((Object)nominatim.getAddress(new MLatLon(57.685575, 11.959081)), (ToStringStyle)ToStringStyle.JSON_STYLE));
    }

    private Nominatim() {
    }

    public Address getAddress(MLatLon latLon) throws IOException {
        return this.getClient().getAddress(latLon.getLongitude(), latLon.getLatitude());
    }

    public Address getAddress(MLatLon latLon, int zoom) throws IOException {
        return this.getClient().getAddress(latLon.getLongitude(), latLon.getLatitude(), zoom);
    }

    public List<Address> search(String string) throws IOException {
        return this.getClient().search(string);
    }

    private JsonNominatimClient getClient() {
        try {
            int timeout = 5000;
            URLConnection urlConnection = new URL("https://mapton.org/files/nominatim-client.properties").openConnection();
            urlConnection.setConnectTimeout(timeout);
            urlConnection.setReadTimeout(timeout);
            urlConnection.connect();
            Properties properties = new Properties();
            properties.load(urlConnection.getInputStream());
            urlConnection.getInputStream().close();
            String baseUrl = properties.getProperty("nominatim.server.url");
            String email = properties.getProperty("nominatim.headerEmail");
            NominatimOptions nominatimOptions = new NominatimOptions();
            nominatimOptions.setAcceptLanguage(Locale.getDefault());
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setSSLSocketFactory((LayeredConnectionSocketFactory)SSLConnectionSocketFactory.getSocketFactory()).build();
            return new JsonNominatimClient(baseUrl, (HttpClient)httpClient, email, nominatimOptions);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    private static class Holder {
        private static final Nominatim INSTANCE = new Nominatim();

        private Holder() {
        }
    }
}

