/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.nominatim;

import fr.dudie.nominatim.model.Address;
import fr.dudie.nominatim.model.BoundingBox;
import java.io.IOException;
import java.util.List;
import org.mapton.api.MLatLon;
import org.mapton.api.MLatLonBox;
import org.mapton.api.Mapton;
import org.mapton.nominatim.Nominatim;
import org.netbeans.spi.quicksearch.SearchProvider;
import org.netbeans.spi.quicksearch.SearchRequest;
import org.netbeans.spi.quicksearch.SearchResponse;

public class NominatimQuickSearchProvider
implements SearchProvider {
    private final Nominatim mNominatim = Nominatim.getInstance();

    public void evaluate(SearchRequest request, SearchResponse response) {
        try {
            List<Address> addresses = this.mNominatim.search(request.getText());
            for (Address address : addresses) {
                if (!response.addResult(() -> {
                    BoundingBox bb = address.getBoundingBox();
                    MLatLonBox latLonBox = new MLatLonBox(new MLatLon(bb.getSouth(), bb.getWest()), new MLatLon(bb.getNorth(), bb.getEast()));
                    Mapton.getEngine().fitToBounds(latLonBox);
                }, address.getDisplayName())) break;
            }
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }
}

