/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util;

import java.awt.event.ActionEvent;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.text.WordUtils;
import se.trixon.almond.util.AlmondAction;
import se.trixon.almond.util.AlmondOptions;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.SystemHelper;

public abstract class AlmondActionManager {
    public static final String ABOUT = "about";
    public static final String ABOUT_DATE_FORMAT = "about_date_format";
    public static final String ADD = "add";
    public static final String CANCEL = "cancel";
    public static final String CLEAR = "clear";
    public static final String CLONE = "clone";
    public static final String CLOSE = "close";
    public static final String FULLSCREEN = "fullScreen";
    public static final String HELP = "help";
    public static final String MENU = "menu";
    public static final String NEW = "new";
    public static final String OPEN = "open";
    public static final String OPTIONS = "options";
    public static final String PROPERTIES = "properties";
    public static final String QUIT = "shutdownServerAndWindow";
    public static final String REDO = "redo";
    public static final String REMOVE = "remove";
    public static final String REMOVE_ALL = "remove_all";
    public static final String RENAME = "rename";
    public static final String SAVE = "save";
    public static final String SAVE_AS = "save_as";
    public static final String START = "start";
    public static final String UNDO = "undo";
    protected static final boolean IS_MAC = SystemUtils.IS_OS_MAC;
    protected ActionMap mActionMap;
    protected final LinkedList<AlmondAction> mActions = new LinkedList();
    protected final AlmondOptions mAlmondOptions = AlmondOptions.getInstance();
    protected final LinkedList<AlmondAction> mBaseActions = new LinkedList();
    protected final LinkedList<AlmondAction> mConditionallyEnabledActions = new LinkedList();
    protected InputMap mInputMap;

    public Action getAction(String key) {
        return this.mActionMap.get(key);
    }

    public LinkedList<AlmondAction> getActions() {
        return this.mActions;
    }

    public LinkedList<AlmondAction> getBaseActions() {
        return this.mBaseActions;
    }

    public LinkedList<AlmondAction> getConditionallyEnabledActions() {
        return this.mConditionallyEnabledActions;
    }

    protected int getOptionsKey() {
        return 44;
    }

    protected void initAboutDateFormatAction() {
        KeyStroke keyStroke = null;
        String title = Dict.ABOUT_S.toString().formatted(Dict.DATE_PATTERN.toString().toLowerCase());
        AlmondAction action = new AlmondAction(title){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemHelper.desktopBrowse("https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html");
            }
        };
        this.initAction(action, ABOUT_DATE_FORMAT, keyStroke, null, true);
    }

    protected void initAction(AlmondAction action, String key, KeyStroke keyStroke, Enum iconEnum, boolean baseAction) {
        action.putValue("almond_key", key);
        action.putValue("AcceleratorKey", keyStroke);
        String shortDescription = (String)action.getValue("Name");
        if (keyStroke != null) {
            String shortcut = WordUtils.capitalizeFully((String)keyStroke.toString());
            shortcut = StringUtils.replace((String)shortcut, (String)" Pressed ", (String)"+");
            shortcut = StringUtils.replace((String)shortcut, (String)"Pressed ", (String)"");
            shortDescription = "%s (%s)".formatted(shortDescription, shortcut);
        }
        action.putValue("ShortDescription", shortDescription);
        action.putValue("hideActionText", true);
        action.setIconEnum(iconEnum);
        action.updateIcon();
        this.mInputMap.put(keyStroke, key);
        this.mActionMap.put(key, action);
        if (baseAction) {
            this.mBaseActions.add(action);
        } else {
            this.mConditionallyEnabledActions.add(action);
        }
        this.mActions.add(action);
    }

    protected void initHelpAction(final String url) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(112, 0);
        AlmondAction action = new AlmondAction(Dict.DOCUMENTATION.toString()){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemHelper.desktopBrowse(url);
            }
        };
        this.initAction(action, HELP, keyStroke, null, true);
    }
}

