/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util;

import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.lang3.SystemUtils;
import se.trixon.almond.util.AlmondUI;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.swing.dialogs.MenuModePanel;
import se.trixon.almond.util.swing.dialogs.Message;

public class AlmondOptions {
    public static final String KEY_FORCE_LOOK_AND_FEEL = "forceLookAndFeel";
    public static final String KEY_ICON_THEME = "lookAndFeelIcons";
    public static final String KEY_LOOK_AND_FEEL = "lookAndFeel";
    public static final String KEY_MENU_ICONS = "displayMenuIcons";
    public static final String KEY_MENU_MODE = "menu_mode";
    private static final boolean DEFAULT_FORCE_LOOK_AND_FEEL = true;
    private static final boolean DEFAULT_MENU_ICONS = !SystemUtils.IS_OS_MAC;
    private static final MenuModePanel.MenuMode DEFAULT_MENU_MODE = SystemUtils.IS_OS_MAC ? MenuModePanel.MenuMode.BAR : MenuModePanel.MenuMode.BUTTON;
    private Color mButtonBackground;
    private String mDefaultLookAndFeel = "System";
    private Preferences mPreferences = Preferences.userNodeForPackage(AlmondOptions.class);
    private boolean mRestartRequired;

    public static AlmondOptions getInstance() {
        return Holder.INSTANCE;
    }

    private AlmondOptions() {
        this.mPreferences.addPreferenceChangeListener(evt -> {
            if (!this.mRestartRequired) {
                this.mRestartRequired = true;
                Message.information(AlmondUI.getInstance().getFrame(), Dict.Dialog.TITLE_RESTART_REQUIRED.toString(), Dict.Dialog.MESSAGE_RESTART_REQUIRED.toString());
            }
            try {
                this.mPreferences.flush();
            }
            catch (BackingStoreException ex) {
                Logger.getLogger(AlmondOptions.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
    }

    public String getDefaultLookAndFeel() {
        return this.mDefaultLookAndFeel;
    }

    public int getIconTheme() {
        return this.mPreferences.getInt(KEY_ICON_THEME, this.getDefaultIconTheme());
    }

    public String getLookAndFeel() {
        return this.mPreferences.get(KEY_LOOK_AND_FEEL, this.getDefaultLookAndFeel());
    }

    public MenuModePanel.MenuMode getMenuMode() {
        return MenuModePanel.MenuMode.values()[this.mPreferences.getInt(KEY_MENU_MODE, DEFAULT_MENU_MODE.ordinal())];
    }

    public Preferences getPreferences() {
        return this.mPreferences;
    }

    public boolean isDisplayMenuIcons() {
        return this.mPreferences.getBoolean(KEY_MENU_ICONS, DEFAULT_MENU_ICONS);
    }

    public boolean isForceLookAndFeel() {
        return this.mPreferences.getBoolean(KEY_FORCE_LOOK_AND_FEEL, true);
    }

    public boolean isMacLookAndFeel() {
        return SystemUtils.IS_OS_MAC && this.getLookAndFeel().equalsIgnoreCase("system") || this.getLookAndFeel().equalsIgnoreCase("mac os x");
    }

    public void setDefaultLookAndFeel(String defaultLookAndFeel) {
        this.mDefaultLookAndFeel = defaultLookAndFeel;
    }

    public void setDisplayMenuIcons(boolean value) {
        if (value != this.isDisplayMenuIcons()) {
            this.mPreferences.putBoolean(KEY_MENU_ICONS, value);
        }
    }

    public void setForceLookAndFeel(boolean value) {
        if (value != this.isForceLookAndFeel()) {
            this.mPreferences.putBoolean(KEY_FORCE_LOOK_AND_FEEL, value);
        }
    }

    public void setIconTheme(int value) {
        if (value != this.getIconTheme()) {
            this.mPreferences.putInt(KEY_ICON_THEME, value);
        }
    }

    public void setLookAndFeel(String value) {
        if (!value.equalsIgnoreCase(this.getLookAndFeel())) {
            this.mPreferences.put(KEY_LOOK_AND_FEEL, value);
        }
    }

    public void setMenuMode(MenuModePanel.MenuMode menuMode) {
        if (menuMode != this.getMenuMode()) {
            this.mPreferences.putInt(KEY_MENU_MODE, menuMode.ordinal());
        }
    }

    public void setPreferences(Preferences preferences) {
        this.mPreferences = preferences;
    }

    private int getDefaultIconTheme() {
        if (this.getLookAndFeel().equalsIgnoreCase("darcula")) {
            return 1;
        }
        return 0;
    }

    private static class Holder {
        private static final AlmondOptions INSTANCE = new AlmondOptions();

        private Holder() {
        }
    }

    public static interface AlmondOptionsWatcher {
        public void onAlmondOptions(AlmondOptionsEvent var1);
    }

    public static enum AlmondOptionsEvent {
        ICON_THEME,
        LOOK_AND_FEEL,
        MENU_ICONS,
        MENU_MODE;

    }
}

