/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ExecutionFlow {
    private final Set<String> mExecutedKeys = Collections.synchronizedSet(new HashSet());
    private final Map<String, ArrayList<Runnable>> mKeyToRunnablesMap = Collections.synchronizedMap(new HashMap());

    public void executeWhenReady(String key, Runnable runnable) {
        this.mKeyToRunnablesMap.computeIfAbsent(key, k -> new ArrayList()).add(runnable);
        if (this.mExecutedKeys.contains(key)) {
            this.execute(key, runnable);
        }
    }

    public void setReady(String key) {
        if (this.mExecutedKeys.add(key)) {
            new HashMap<String, ArrayList<Runnable>>(this.mKeyToRunnablesMap).entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(key)).forEachOrdered(entry -> ((ArrayList)entry.getValue()).forEach(runnable -> this.execute(key, (Runnable)runnable)));
        }
    }

    private void execute(String key, Runnable runnable) {
        new Thread(runnable, "%s/%s".formatted(this.getClass().getSimpleName(), key)).start();
    }
}

