/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import se.trixon.almond.util.Scaler;

public class ImageScaler {
    private final GraphicsConfiguration mGraphicsConfiguration;
    private final GraphicsDevice mGraphicsDevice;
    private final GraphicsEnvironment mGraphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();

    public static ImageScaler getInstance() {
        return Holder.INSTANCE;
    }

    private ImageScaler() {
        this.mGraphicsDevice = this.mGraphicsEnvironment.getDefaultScreenDevice();
        this.mGraphicsConfiguration = this.mGraphicsDevice.getDefaultConfiguration();
    }

    public BufferedImage getScaledImage(File file, double ratio) throws IOException {
        return this.getScaledImage(ImageIO.read(file), ratio);
    }

    public BufferedImage getScaledImage(File file, Dimension dimension) throws IOException {
        return this.getScaledImage(ImageIO.read(file), dimension);
    }

    public BufferedImage getScaledImage(BufferedImage originalBufferedImage, Dimension maxDimension) {
        Scaler scaler = new Scaler(new Dimension(originalBufferedImage.getWidth(), originalBufferedImage.getHeight()));
        scaler.setHeight(maxDimension.height);
        scaler.setWidth(maxDimension.width);
        int w = scaler.getDimension().width;
        int h = scaler.getDimension().height;
        BufferedImage scaledBufferedImage = this.mGraphicsConfiguration.createCompatibleImage(w, h, 1);
        Graphics2D g2d = scaledBufferedImage.createGraphics();
        double xScale = (double)w / (double)originalBufferedImage.getWidth();
        double yScale = (double)h / (double)originalBufferedImage.getHeight();
        AffineTransform affineTransform = AffineTransform.getScaleInstance(xScale, yScale);
        g2d.drawRenderedImage(originalBufferedImage, affineTransform);
        g2d.dispose();
        return scaledBufferedImage;
    }

    public BufferedImage getScaledImage(BufferedImage originalBufferedImage, double ratio) {
        int w = (int)((double)originalBufferedImage.getWidth() * ratio);
        int h = (int)((double)originalBufferedImage.getHeight() * ratio);
        return this.getScaledImage(originalBufferedImage, new Dimension(w, h));
    }

    private static class Holder {
        private static final ImageScaler INSTANCE = new ImageScaler();

        private Holder() {
        }
    }
}

