/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import se.trixon.almond.util.LogListener;

public class Log {
    public static final int ASSERT = 7;
    public static final int DEBUG = 3;
    public static final int ERROR = 6;
    public static final int INFO = 4;
    public static final int VERBOSE = 2;
    public static final int WARN = 5;
    public String mGlobalTag = "";
    private boolean mActive = true;
    private DateTimeFormatter mDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH.mm.ss: ");
    private LogListener mErr = s -> System.err.println(s);
    private int mLevel = 2;
    private LogListener mOut = s -> System.out.println(s);
    private boolean mUseGlobalTag = false;
    private boolean mUseTimestamps = true;

    public Log(LogListener out, LogListener err) {
        this.mOut = out;
        this.mErr = err;
    }

    public Log() {
    }

    public synchronized void a(Class c, String msg) {
        this.a(this.getTag(c.getCanonicalName()), msg);
    }

    public synchronized void a(String tag, String msg) {
        if (this.mActive && this.mLevel <= 7) {
            this.printErr("ASSERT", this.getMessage(this.getTag(tag), StringUtils.defaultString((String)msg, (String)"NULL")));
        }
    }

    public synchronized void d(Class c, String msg) {
        this.d(this.getTag(c.getCanonicalName()), msg);
    }

    public synchronized void d(String tag, String msg) {
        if (this.mActive && this.mLevel <= 3) {
            this.print("DEBUG", this.getMessage(this.getTag(tag), StringUtils.defaultString((String)msg, (String)"NULL")));
        }
    }

    public synchronized void e(Class c, String msg) {
        this.e(this.getTag(c.getCanonicalName()), msg);
    }

    public synchronized void e(String tag, String msg) {
        if (this.mActive && this.mLevel <= 6) {
            this.printErr("ERROR", this.getMessage(this.getTag(tag), StringUtils.defaultString((String)msg, (String)"NULL")));
        }
    }

    public synchronized void err(String message) {
        this.mErr.println(message);
    }

    public synchronized String getGlobalTag() {
        return this.mGlobalTag;
    }

    public synchronized int getLevel() {
        return this.mLevel;
    }

    public synchronized void i(Class c, String msg) {
        this.i(this.getTag(c.getCanonicalName()), msg);
    }

    public synchronized void i(String tag, String msg) {
        if (this.mActive && this.mLevel <= 4) {
            this.print("INFO", this.getMessage(this.getTag(tag), StringUtils.defaultString((String)msg, (String)"NULL")));
        }
    }

    public synchronized boolean isActive() {
        return this.mActive;
    }

    public synchronized boolean isUseGlobalTag() {
        return this.mUseGlobalTag;
    }

    public synchronized boolean isUseTimestamps() {
        return this.mUseTimestamps;
    }

    public synchronized void out(String message) {
        this.mOut.println(message);
    }

    public synchronized void setActive(boolean active) {
        this.mActive = active;
    }

    public void setErr(LogListener logListener) {
        this.mErr = logListener;
    }

    public synchronized void setGlobalTag(String globalTag) {
        this.mGlobalTag = globalTag;
    }

    public synchronized void setLevel(int level) {
        this.mLevel = level;
    }

    public void setOut(LogListener logListener) {
        this.mOut = logListener;
    }

    public synchronized void setUseGlobalTag(boolean useGlobalTag) {
        this.mUseGlobalTag = useGlobalTag;
    }

    public synchronized void setUseTimestamps(boolean useTimestamps) {
        this.mUseTimestamps = useTimestamps;
    }

    public synchronized void timedErr(String message) {
        this.mErr.println(this.getDate() + message);
    }

    public synchronized void timedOut(String message) {
        this.mOut.println(this.getDate() + message);
    }

    public synchronized void v(Class<?> c, String msg) {
        this.v(this.getTag(c.getCanonicalName()), msg);
    }

    public synchronized void v(String tag, String msg) {
        if (this.mActive && this.mLevel <= 2) {
            this.print("VERBOSE", this.getMessage(this.getTag(tag), StringUtils.defaultString((String)msg, (String)"NULL")));
        }
    }

    public synchronized void w(Class c, String msg) {
        this.w(this.getTag(c.getCanonicalName()), msg);
    }

    public synchronized void w(String tag, String msg) {
        if (this.mActive && this.mLevel <= 5) {
            this.printErr("WARNING", this.getMessage(this.getTag(tag), StringUtils.defaultString((String)msg, (String)"NULL")));
        }
    }

    private String getDate() {
        return this.mUseTimestamps ? LocalDateTime.now().format(this.mDateTimeFormatter) : "";
    }

    private String getMessage(String s1, String s2) {
        return "[%s] %s".formatted(s1, s2);
    }

    private String getMessage(String s1, String s2, String s3) {
        return "[%s] [%s] %s".formatted(s1, s2, s3);
    }

    private String getTag(String localTag) {
        String tag = this.mUseGlobalTag ? this.mGlobalTag : localTag;
        return tag;
    }

    private void print(String levelClass, String message) {
        this.mOut.println("%s%s %s".formatted(this.getDate(), levelClass, message));
    }

    private void printErr(String levelClass, String message) {
        this.mErr.println("%s%s %s".formatted(this.getDate(), levelClass, message));
    }
}

