/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MailHelper {
    public static URI generateMailToUri(String mailTo, String subject, String cc, String body) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        MailHelper.add(map, "mailto:", mailTo);
        MailHelper.add(map, "subject", subject);
        MailHelper.add(map, "cc", cc);
        MailHelper.add(map, "body", body);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(entry.getKey()).append(entry.getValue());
        }
        try {
            return new URI(sb.toString());
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public static void mail(URI mailToURI) {
        try {
            Desktop.getDesktop().mail(mailToURI);
        }
        catch (IOException ex) {
            Logger.getLogger(MailHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static void add(LinkedHashMap<String, String> map, String key, String value) {
        if (value != null) {
            int i = map.size();
            String prefix = "";
            if (i == 1) {
                prefix = "?";
            } else if (i > 1) {
                prefix = "&";
            }
            String postfix = i > 0 ? "=" : "";
            map.put(prefix + key + postfix, URLEncoder.encode(value, StandardCharsets.UTF_8));
        }
    }
}

