/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util;

import java.awt.Dimension;
import java.awt.Point;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import javafx.geometry.Point2D;

public class MathHelper {
    public static Point2D calculateCircleCenter(Point2D p1, Point2D p2, double r) {
        double x1 = p1.getX();
        double y1 = p1.getY();
        double x2 = p2.getX();
        double y2 = p2.getY();
        double d = p1.distance(p2);
        double x3 = (x1 + x2) / 2.0;
        double y3 = (y1 + y2) / 2.0;
        double q = Math.signum(r) * Math.sqrt(r * r - Math.pow(d / 2.0, 2.0)) / d;
        double x = x3 - q * (y1 - y2);
        double y = y3 - q * (x2 - x1);
        return new Point2D(x, y);
    }

    public static double convertDoubleToDouble(Double d) {
        return d == null ? 0.0 : d;
    }

    public static String convertDoubleToString(Locale locale, Double d, int decimals) {
        if (d == null) {
            return "";
        }
        String format = "%%.%df".formatted(decimals);
        return String.format(locale, format, d);
    }

    public static String convertDoubleToString(Locale locale, Double d) {
        if (d == null) {
            return "";
        }
        return String.format(locale, "%f", d);
    }

    public static String convertDoubleToString(Double d, int decimals) {
        return MathHelper.convertDoubleToString(Locale.getDefault(), d, decimals);
    }

    public static String convertDoubleToString(Double d) {
        return MathHelper.convertDoubleToString(Locale.getDefault(), d);
    }

    public static Integer convertIntegerToInteger(Integer i) {
        return i == null ? 0 : i;
    }

    public static String convertIntegerToString(Integer i) {
        return i == null ? null : i.toString();
    }

    public static String convertLongToString(Long l, boolean suppressNull) {
        return l == null ? (suppressNull ? "" : null) : l.toString();
    }

    public static Double convertStringToDouble(String s) {
        return s == null || s.trim().isEmpty() ? null : Double.valueOf(s.trim());
    }

    public static Integer convertStringToInteger(String s) {
        return s == null || s.trim().isEmpty() ? null : Integer.valueOf(s.trim());
    }

    public static Point indexToPoint(int index, Dimension d) {
        return new Point(index % d.width, index / d.width);
    }

    public static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NullPointerException | NumberFormatException e) {
            return false;
        }
    }

    public static void main(String[] args) {
        System.out.println(MathHelper.pointToIndex(new Point(3, 1), new Dimension(5, 3)));
        System.out.println(MathHelper.indexToPoint(14, new Dimension(5, 3)));
    }

    public static int pointToIndex(Point p, Dimension d) {
        return p.y * d.width + p.x;
    }

    public static int round(double value) {
        return (int)Math.round(value);
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        return BigDecimal.valueOf(value).setScale(places, RoundingMode.HALF_UP).doubleValue();
    }
}

