/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import se.trixon.almond.util.Dict;

public class StringHelper {
    private static final byte[] HEX_ARRAY = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);

    public static String arrayToIntervalString(int[] indices) {
        if (indices == null || indices.length == 0) {
            return "";
        }
        for (int index : indices) {
            if (index >= 0) continue;
            return "";
        }
        Arrays.sort(indices);
        StringBuilder builder = new StringBuilder();
        LinkedList<BlockItem> blockItems = new LinkedList<BlockItem>();
        int prev = -1;
        int lastStart = 0;
        int length = 0;
        for (int i = 0; i < indices.length; ++i) {
            boolean endOfBlock;
            int next;
            int current = indices[i];
            if (i == 0) {
                lastStart = current;
                prev = current - 1;
            } else if (length == 0) {
                lastStart = current;
            }
            ++length;
            try {
                next = indices[i + 1];
            }
            catch (IndexOutOfBoundsException e) {
                next = -1;
            }
            boolean bl = endOfBlock = current > prev + 1 || i == indices.length - 1;
            if (next > -1 && !endOfBlock) {
                boolean bl2 = endOfBlock = current + 1 < next;
            }
            if (endOfBlock) {
                BlockItem blockItem = new BlockItem();
                blockItem.length = length;
                blockItem.start = lastStart;
                blockItems.add(blockItem);
                length = 0;
            }
            prev = next - 1;
        }
        for (BlockItem blockItem : blockItems) {
            builder.append(blockItem.start);
            if (blockItem.length == 2) {
                builder.append(",").append(blockItem.start + 1);
            } else if (blockItem.length > 2) {
                builder.append("-").append(blockItem.start + blockItem.length - 1);
            }
            builder.append(",");
        }
        char lastChar = builder.charAt(builder.length() - 1);
        if (lastChar == ',') {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String booleanToYesNo(boolean value) {
        return value ? Dict.YES.toString() : Dict.NO.toString();
    }

    public static String bytesToHex(byte[] bytes) {
        byte[] hexChars = new byte[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }

    public static TreeSet<Integer> convertStringToIntSet(String string) {
        String[] args;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (String arg : args = string.split(",")) {
            try {
                int value = Integer.valueOf(arg.trim());
                treeSet.add(value);
            }
            catch (NumberFormatException e) {
                String[] interval = arg.split("-");
                int start = Math.min(Integer.valueOf(interval[0].trim()), Integer.valueOf(interval[1].trim()));
                int stop = Math.max(Integer.valueOf(interval[0].trim()), Integer.valueOf(interval[1].trim()));
                for (int j = start; j <= stop; ++j) {
                    treeSet.add(j);
                }
            }
        }
        return treeSet;
    }

    public static String createRegexFromGlob(String glob) {
        Object out = "^";
        block6: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    out = (String)out + ".*";
                    continue block6;
                }
                case '?': {
                    out = (String)out + ".";
                    continue block6;
                }
                case '.': {
                    out = (String)out + "\\.";
                    continue block6;
                }
                case '\\': {
                    out = (String)out + "\\\\";
                    continue block6;
                }
                default: {
                    out = (String)out + c;
                }
            }
        }
        out = (String)out + "$";
        return out;
    }

    public static String getTheOtherOne(String s, String s1, String s2) {
        if (s == null) {
            return null;
        }
        if (StringUtils.equals((CharSequence)s, (CharSequence)s1)) {
            return s2;
        }
        if (StringUtils.equals((CharSequence)s, (CharSequence)s2)) {
            return s1;
        }
        return null;
    }

    public static String[] intervalStringToArray(String intervalString) {
        String[] intervalItems;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String intervalItem : intervalItems = StringUtils.split((String)intervalString, (String)",")) {
            if ((intervalItem = intervalItem.trim()).contains("-")) {
                String[] startStop = StringUtils.split((String)intervalItem, (String)"-");
                int start = Integer.valueOf(startStop[0]);
                int stop = Integer.valueOf(startStop[1]);
                for (int i = start; i < stop + 1; ++i) {
                    arrayList.add(String.valueOf(i));
                }
                continue;
            }
            arrayList.add(intervalItem);
        }
        return (String[])Arrays.copyOf(arrayList.toArray(), arrayList.toArray().length, String[].class);
    }

    public static boolean matchesSimpleGlob(String searchIn, String glob, boolean ignoreCase, boolean autoWrap) {
        searchIn = StringUtils.defaultString((String)searchIn);
        glob = StringUtils.defaultString((String)glob);
        if (autoWrap && !StringUtils.contains((CharSequence)glob, (CharSequence)"*")) {
            glob = "*" + (String)glob + "*";
        }
        String regex = StringHelper.createRegexFromGlob((String)glob);
        try {
            if (ignoreCase) {
                return searchIn.toLowerCase().matches(regex);
            }
            return searchIn.matches(regex);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    private static class BlockItem {
        private int length;
        private int start;

        private BlockItem() {
        }

        public String toString() {
            return "BlockItem{start=" + this.start + ", length=" + this.length + "}";
        }
    }
}

