/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util;

import java.awt.image.BufferedImage;
import java.util.Map;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import se.trixon.almond.util.SystemHelper;

public class SystemHelperFx
extends SystemHelper {
    public static boolean copyToClipboard(BufferedImage bufferedImage) {
        return SystemHelperFx.copyToClipboard((Image)SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null));
    }

    public static boolean copyToClipboard(Image image) {
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putImage(image);
        return Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
    }

    public static Image getResourceAsImage(Class cls, String name) {
        Image image = null;
        try {
            String path = "/%s%s".formatted(SystemHelperFx.getPackageAsPath(cls), name);
            image = new Image(path);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return image;
    }

    public static ImageView getResourceAsImageView(Class cls, String name) {
        ImageView imageView = null;
        try {
            String path = "/%s%s".formatted(SystemHelperFx.getPackageAsPath(cls), name);
            imageView = new ImageView(new Image(path));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return imageView;
    }
}

