/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.ext;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;

public final class GrahamScan {
    public static List<Point> getConvexHull(int[] xs, int[] ys) throws IllegalArgumentException {
        if (xs.length != ys.length) {
            throw new IllegalArgumentException("xs and ys don't have the same size");
        }
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < xs.length; ++i) {
            points.add(new Point(xs[i], ys[i]));
        }
        return GrahamScan.getConvexHull(points);
    }

    public static List<Point> getConvexHull(List<Point> points) throws IllegalArgumentException {
        ArrayList<Point> sorted = new ArrayList<Point>(GrahamScan.getSortedPointSet(points));
        if (sorted.size() < 3) {
            throw new IllegalArgumentException("can only create a convex hull of 3 or more unique points");
        }
        if (GrahamScan.areAllCollinear(sorted)) {
            throw new IllegalArgumentException("cannot create a convex hull from collinear points");
        }
        Stack<Point> stack = new Stack<Point>();
        stack.push((Point)sorted.get(0));
        stack.push((Point)sorted.get(1));
        block5: for (int i = 2; i < sorted.size(); ++i) {
            Point head = (Point)sorted.get(i);
            Point middle = (Point)stack.pop();
            Point tail = (Point)stack.peek();
            Turn turn = GrahamScan.getTurn(tail, middle, head);
            switch (turn) {
                case COUNTER_CLOCKWISE: {
                    stack.push(middle);
                    stack.push(head);
                    continue block5;
                }
                case CLOCKWISE: {
                    --i;
                    continue block5;
                }
                case COLLINEAR: {
                    stack.push(head);
                }
            }
        }
        stack.push((Point)sorted.get(0));
        return new ArrayList<Point>(stack);
    }

    public static List<Point2D.Double> getConvexHullDouble(List<Point2D.Double> pointsDouble) throws IllegalArgumentException {
        double factor = 1000000.0;
        ArrayList<Point> points = new ArrayList<Point>();
        pointsDouble.forEach(pointDouble -> points.add(new Point((int)(pointDouble.x * 1000000.0), (int)(pointDouble.y * 1000000.0))));
        ArrayList<Point2D.Double> convexHull = new ArrayList<Point2D.Double>();
        List<Point> intConvexHull = GrahamScan.getConvexHull(points);
        intConvexHull.forEach(point -> convexHull.add(new Point2D.Double((double)point.x / 1000000.0, (double)point.y / 1000000.0)));
        return convexHull;
    }

    protected static boolean areAllCollinear(List<Point> points) {
        if (points.size() < 2) {
            return true;
        }
        Point a = points.get(0);
        Point b = points.get(1);
        for (int i = 2; i < points.size(); ++i) {
            Point c = points.get(i);
            if (GrahamScan.getTurn(a, b, c) == Turn.COLLINEAR) continue;
            return false;
        }
        return true;
    }

    protected static Point getLowestPoint(List<Point> points) {
        Point lowest = points.get(0);
        for (int i = 1; i < points.size(); ++i) {
            Point temp = points.get(i);
            if (temp.y >= lowest.y && (temp.y != lowest.y || temp.x >= lowest.x)) continue;
            lowest = temp;
        }
        return lowest;
    }

    protected static Set<Point> getSortedPointSet(List<Point> points) {
        Point lowest = GrahamScan.getLowestPoint(points);
        TreeSet<Point> set = new TreeSet<Point>((a, b) -> {
            double distanceB;
            double thetaB;
            if (a == b || a.equals(b)) {
                return 0;
            }
            double thetaA = Math.atan2((double)a.y - (double)lowest.y, (double)a.x - (double)lowest.x);
            if (thetaA < (thetaB = Math.atan2((double)b.y - (double)lowest.y, (double)b.x - (double)lowest.x))) {
                return -1;
            }
            if (thetaA > thetaB) {
                return 1;
            }
            double distanceA = Math.sqrt((double)(((long)lowest.x - (long)a.x) * ((long)lowest.x - (long)a.x)) + (double)((long)lowest.y - (long)a.y) * (double)((long)lowest.y - (long)a.y));
            if (distanceA < (distanceB = Math.sqrt((double)(((long)lowest.x - (long)b.x) * ((long)lowest.x - (long)b.x)) + (double)((long)lowest.y - (long)b.y) * (double)((long)lowest.y - (long)b.y)))) {
                return -1;
            }
            return 1;
        });
        set.addAll(points);
        return set;
    }

    protected static Turn getTurn(Point a, Point b, Point c) {
        long crossProduct = ((long)b.x - (long)a.x) * ((long)c.y - (long)a.y) - ((long)b.y - (long)a.y) * ((long)c.x - (long)a.x);
        if (crossProduct > 0L) {
            return Turn.COUNTER_CLOCKWISE;
        }
        if (crossProduct < 0L) {
            return Turn.CLOCKWISE;
        }
        return Turn.COLLINEAR;
    }

    protected static enum Turn {
        CLOCKWISE,
        COUNTER_CLOCKWISE,
        COLLINEAR;

    }
}

