/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.fx;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CategoryActionManager {
    private final HashMap<String, HashSet<Object>> mCategoryActions = new HashMap();

    public static CategoryActionManager getInstance() {
        return Holder.INSTANCE;
    }

    private CategoryActionManager() {
    }

    public boolean add(String category, Object o) {
        try {
            Method method = o.getClass().getMethod("setDisabled", Boolean.TYPE);
            return this.getActions(category).add(o);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            Logger.getLogger(CategoryActionManager.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public void addAll(String category, Object ... actions) {
        for (Object action : actions) {
            this.getActions(category).add(action);
        }
    }

    public void clear(String category) {
        this.getActions(category).clear();
    }

    public HashSet<Object> getActions(String category) {
        return this.mCategoryActions.computeIfAbsent(category, k -> new HashSet());
    }

    public boolean remove(String category, Object action) {
        return this.getActions(category).remove(action);
    }

    public void setEnabled(String category, boolean enabled) {
        this.getActions(category).forEach(o -> {
            try {
                Method method = o.getClass().getMethod("setDisabled", Boolean.TYPE);
                method.invoke(o, !enabled);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                try {
                    Method method = o.getClass().getMethod("setDisable", Boolean.TYPE);
                    method.invoke(o, !enabled);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex2) {
                    Logger.getLogger(CategoryActionManager.class.getName()).log(Level.SEVERE, null, ex2);
                }
            }
        });
    }

    private static class Holder {
        private static final CategoryActionManager INSTANCE = new CategoryActionManager();

        private Holder() {
        }
    }
}

