/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.fx;

import java.util.HashMap;
import java.util.HashSet;
import javafx.beans.property.BooleanProperty;

public class CategoryBooleanManager {
    private final HashMap<String, HashSet<BooleanProperty>> mCategoryActions = new HashMap();

    public static CategoryBooleanManager getInstance() {
        return Holder.INSTANCE;
    }

    private CategoryBooleanManager() {
    }

    public boolean add(String category, BooleanProperty booleanProperty) {
        return this.getActions(category).add(booleanProperty);
    }

    public void addAll(String category, BooleanProperty ... booleanPropertys) {
        for (BooleanProperty booleanProperty : booleanPropertys) {
            this.getActions(category).add(booleanProperty);
        }
    }

    public void clear(String category) {
        this.getActions(category).clear();
    }

    public HashSet<BooleanProperty> getActions(String category) {
        return this.mCategoryActions.computeIfAbsent(category, k -> new HashSet());
    }

    public boolean remove(String category, BooleanProperty booleanProperty) {
        return this.getActions(category).remove(booleanProperty);
    }

    public void setEnabled(String category, boolean enabled) {
        this.getActions(category).forEach(booleanProperty -> booleanProperty.set(enabled));
    }

    private static class Holder {
        private static final CategoryBooleanManager INSTANCE = new CategoryBooleanManager();

        private Holder() {
        }
    }
}

