/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.fx;

import java.awt.Color;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Point3D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.Labeled;
import javafx.scene.control.ListView;
import javafx.scene.control.Spinner;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.control.skin.ListViewSkin;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.lang3.ArrayUtils;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.control.action.Action;
import se.trixon.almond.util.PrefsHelper;
import se.trixon.almond.util.icons.material.MaterialIcon;
import se.trixon.almond.util.swing.SwingHelper;

public class FxHelper {
    public static final String STYLE_HOVERED_BUTTON = "-fx-background-color: -fx-shadow-highlight-color, -fx-outer-border, -fx-inner-border, -fx-body-color;";
    public static final String STYLE_IDLE_BUTTON = "-fx-background-color: transparent;";
    private static final String DARCULA = "darcula.css";
    private static final String FORMAT_HEX_3 = "%02X%02X%02X";
    private static final String FORMAT_HEX_4 = "%02X%02X%02X%02X";
    private static final String FORMAT_TITLE_DESC = "%s (%s)";
    private static final String STAGE_ALWAYS_ON_TOP = "AlmondStage_AlwaysOnTop";
    private static final String STAGE_FULL_SCREEN = "AlmondStage_FullScreen";
    private static final String STAGE_H = "AlmondStage_Height";
    private static final String STAGE_MAXIMIZED = "AlmondStage_Maximized";
    private static final String STAGE_W = "AlmondStage_Width";
    private static final String STAGE_X = "AlmondStage_X";
    private static final String STAGE_Y = "AlmondStage_Y";
    private static double UI_SCALE = 1.0;
    private static javafx.scene.paint.Color sDarkColor = javafx.scene.paint.Color.web((String)"#3c3f41");

    public static void adjustButtonHeight(Stream<Node> stream, double prefHeight) {
        stream.filter(item -> item instanceof ButtonBase).map(item -> (ButtonBase)item).forEachOrdered(buttonBase -> buttonBase.setPrefHeight(prefHeight));
    }

    public static void adjustButtonWidth(Stream<Node> stream, double prefWidth) {
        stream.filter(item -> item instanceof ButtonBase).map(item -> (ButtonBase)item).forEachOrdered(buttonBase -> buttonBase.setPrefWidth(prefWidth));
    }

    public static void applyFontScale(Scene scene) {
        FxHelper.runLater(() -> scene.getRoot().setStyle("-fx-font-size: %dpx;".formatted((int)FxHelper.getScaledFontSize())));
    }

    public static void autoCommitSpinner(Spinner spinner) {
        spinner.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                spinner.increment(0);
            }
        });
    }

    public static void autoCommitSpinners(Spinner ... spinners) {
        for (Spinner spinner : spinners) {
            FxHelper.autoCommitSpinner(spinner);
        }
    }

    public static void autoSizeColumn(GridPane gridPane, int columnCount) {
        gridPane.getColumnConstraints().clear();
        for (int i = 0; i < columnCount; ++i) {
            ColumnConstraints columnConstraints = new ColumnConstraints();
            columnConstraints.setPercentWidth(100.0 / (double)columnCount);
            gridPane.getColumnConstraints().add((Object)columnConstraints);
        }
    }

    @Deprecated
    public static void autoSizeRegion(Region ... regions) {
        FxHelper.autoSizeRegionHorizontal(regions);
    }

    public static void autoSizeRegionHorizontal(Region ... regions) {
        for (Region region : regions) {
            GridPane.setHgrow((Node)region, (Priority)Priority.ALWAYS);
            GridPane.setFillWidth((Node)region, (Boolean)true);
            region.setMaxWidth(Double.MAX_VALUE);
        }
    }

    public static void autoSizeRegionVertical(Region ... regions) {
        for (Region region : regions) {
            GridPane.setVgrow((Node)region, (Priority)Priority.ALWAYS);
            GridPane.setFillHeight((Node)region, (Boolean)true);
            region.setMaxHeight(Double.MAX_VALUE);
        }
    }

    public static void clearText(Text ... texts) {
        for (Text text : texts) {
            text.setText("");
        }
    }

    public static void clearLabel(Labeled ... labels) {
        for (Labeled label : labels) {
            label.setText("");
        }
    }

    public static javafx.scene.paint.Color colorFromHexRGBA(String rgba) {
        return javafx.scene.paint.Color.web((String)rgba);
    }

    public static Color colorToColor(javafx.scene.paint.Color color) {
        if (color == null) {
            return Color.BLACK;
        }
        return new Color((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getOpacity());
    }

    @Deprecated
    public static String colorToHex(javafx.scene.paint.Color color) {
        return FORMAT_HEX_3.formatted((int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0));
    }

    public static String colorToHexABGR(javafx.scene.paint.Color color) {
        return FORMAT_HEX_4.formatted((int)(color.getOpacity() * 255.0), (int)(color.getBlue() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getRed() * 255.0));
    }

    public static String colorToHexABGR(Color color) {
        return FORMAT_HEX_4.formatted(color.getAlpha(), color.getBlue(), color.getGreen(), color.getRed());
    }

    public static String colorToHexBGR(javafx.scene.paint.Color color) {
        return FORMAT_HEX_3.formatted((int)(color.getBlue() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getRed() * 255.0));
    }

    public static String colorToHexBGR(Color color) {
        return FORMAT_HEX_3.formatted(color.getBlue(), color.getGreen(), color.getRed());
    }

    public static int colorToHexInt(javafx.scene.paint.Color color) {
        return Integer.decode("0x" + FxHelper.colorToHex(color));
    }

    public static String colorToHexRGB(javafx.scene.paint.Color color) {
        return FORMAT_HEX_3.formatted((int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0));
    }

    public static String colorToHexRGB(Color color) {
        return FORMAT_HEX_3.formatted(color.getBlue(), color.getGreen(), color.getRed());
    }

    public static String colorToHexRGBA(Color color) {
        return FORMAT_HEX_4.formatted(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static String colorToHexRGBA(javafx.scene.paint.Color color) {
        return FORMAT_HEX_4.formatted((int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0), (int)(color.getOpacity() * 255.0));
    }

    public static int colorToInt(javafx.scene.paint.Color color) {
        int r = (int)(color.getRed() * 255.0);
        int g = (int)(color.getGreen() * 255.0);
        int b = (int)(color.getBlue() * 255.0);
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static String colorToString(javafx.scene.paint.Color color) {
        return "#" + FxHelper.colorToHex(color);
    }

    public static Background createBackground(javafx.scene.paint.Color color) {
        return new Background(new BackgroundFill[]{new BackgroundFill((Paint)color, CornerRadii.EMPTY, Insets.EMPTY)});
    }

    public static String createKeyCodeDisplayText(KeyCode code, KeyCombination.Modifier ... modifiers) {
        return new KeyCodeCombination(code, modifiers).getDisplayText();
    }

    public static String createTitleAndKeyCode(String title, KeyCode code, KeyCombination.Modifier ... modifiers) {
        return FORMAT_TITLE_DESC.formatted(title, FxHelper.createKeyCodeDisplayText(code, modifiers));
    }

    public static Tooltip createTitleAndKeyCodeTooltip(String title, KeyCode code, KeyCombination.Modifier ... modifiers) {
        return new Tooltip(FxHelper.createTitleAndKeyCode(title, code, modifiers));
    }

    public static void disableControls(ObservableList<Node> nodes, boolean disabled, Control ... excludedControls) {
        for (Node node : nodes) {
            if (ArrayUtils.contains((Object[])excludedControls, (Object)node)) continue;
            if (node instanceof Pane) {
                Pane pane = (Pane)node;
                FxHelper.disableControls((ObservableList<Node>)pane.getChildrenUnmodifiable(), disabled, excludedControls);
                continue;
            }
            if (node instanceof ToolBar) {
                ToolBar toolBar = (ToolBar)node;
                FxHelper.disableControls((ObservableList<Node>)toolBar.getItems(), disabled, excludedControls);
                continue;
            }
            try {
                node.setDisable(disabled);
            }
            catch (Exception exception) {}
        }
    }

    public static ButtonBase getButtonForAction(Action action, ObservableList<Node> items) {
        for (Node item : items) {
            ButtonBase buttonBase;
            if (!(item instanceof ButtonBase) || !(buttonBase = (ButtonBase)item).getOnAction().equals((Object)action)) continue;
            return buttonBase;
        }
        return null;
    }

    public static javafx.scene.paint.Color getDarkColor() {
        return sDarkColor;
    }

    public static double getScaledFontSize() {
        return Font.getDefault().getSize() * SwingHelper.getUIScale();
    }

    public static Tooltip getTooltip(String text, KeyCodeCombination keyCodeCombination) {
        return new Tooltip(FORMAT_TITLE_DESC.formatted(text, keyCodeCombination.getDisplayText()));
    }

    public static double getUIScaleX() {
        return UI_SCALE;
    }

    public static double getUIScaled(double value) {
        return value * SwingHelper.getUIScale();
    }

    public static int getUIScaled(int value) {
        return (int)((double)value * SwingHelper.getUIScale());
    }

    public static Insets getUIScaledInsets(double topRightBottomLeft) {
        return new Insets(topRightBottomLeft * SwingHelper.getUIScale());
    }

    public static Insets getUIScaledInsets(double top, double right, double bottom, double left) {
        return new Insets(top * SwingHelper.getUIScale(), right * SwingHelper.getUIScale(), bottom * SwingHelper.getUIScale(), left * SwingHelper.getUIScale());
    }

    public static boolean isAlwaysOnTop(Class c) {
        return Preferences.userNodeForPackage(c).getBoolean(STAGE_ALWAYS_ON_TOP, false);
    }

    public static boolean isDarkThemeEnabled() {
        return Boolean.getBoolean("trixon.almond.fx.dark");
    }

    public static boolean isFullScreen(Class c) {
        return Preferences.userNodeForPackage(c).getBoolean(STAGE_FULL_SCREEN, false);
    }

    public static void loadDarkTheme(Scene scene) {
        FxHelper.runLater(() -> {
            if (FxHelper.isDarkThemeEnabled()) {
                scene.getStylesheets().add((Object)FxHelper.class.getResource(DARCULA).toExternalForm());
            }
            FxHelper.applyFontScale(scene);
        });
    }

    public static void loadDarkTheme(Parent parent) {
        if (FxHelper.isDarkThemeEnabled()) {
            FxHelper.runLater(() -> parent.getStylesheets().add((Object)FxHelper.class.getResource(DARCULA).toExternalForm()));
        }
    }

    public static void loadDarkTheme(Parent ... parents) {
        if (FxHelper.isDarkThemeEnabled()) {
            for (Parent parent : parents) {
                FxHelper.loadDarkTheme(parent);
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(FxHelper.colorToHexBGR(Color.red));
    }

    public static void matrixRotateNode(Node node, double alf, double bet, double gam) {
        double A11 = Math.cos(alf) * Math.cos(gam);
        double A12 = Math.cos(bet) * Math.sin(alf) + Math.cos(alf) * Math.sin(bet) * Math.sin(gam);
        double A13 = Math.sin(alf) * Math.sin(bet) - Math.cos(alf) * Math.cos(bet) * Math.sin(gam);
        double A21 = -Math.cos(gam) * Math.sin(alf);
        double A22 = Math.cos(alf) * Math.cos(bet) - Math.sin(alf) * Math.sin(bet) * Math.sin(gam);
        double A23 = Math.cos(alf) * Math.sin(bet) + Math.cos(bet) * Math.sin(alf) * Math.sin(gam);
        double A31 = Math.sin(gam);
        double A32 = -Math.cos(gam) * Math.sin(bet);
        double A33 = Math.cos(bet) * Math.cos(gam);
        double d = Math.acos((A11 + A22 + A33 - 1.0) / 2.0);
        if (d != 0.0) {
            double den = 2.0 * Math.sin(d);
            Point3D p = new Point3D((A32 - A23) / den, (A13 - A31) / den, (A21 - A12) / den);
            node.setRotationAxis(p);
            node.setRotate(Math.toDegrees(d));
        }
    }

    public static void notify(String message, NotificationPane notificationPane, MaskerPane maskerPane, int iconSize) {
        FxHelper.runLater(() -> {
            maskerPane.setVisible(false);
            notificationPane.show(message, (Node)MaterialIcon._Action.INFO_OUTLINE.getImageView(iconSize));
        });
        new Thread(() -> {
            try {
                TimeUnit.MILLISECONDS.sleep(3000L);
                FxHelper.runLater(() -> notificationPane.hide());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    public static void removeSceneInitFlicker(Window window) {
        if (FxHelper.isDarkThemeEnabled()) {
            window.getScene().setFill((Paint)FxHelper.getDarkColor());
        }
    }

    public static void removeSceneInitFlicker(Node node) {
        if (FxHelper.isDarkThemeEnabled()) {
            node.getScene().setFill((Paint)FxHelper.getDarkColor());
        }
    }

    public static void runLater(Runnable r) {
        if (Platform.isFxApplicationThread()) {
            r.run();
        } else {
            Platform.runLater((Runnable)r);
        }
    }

    public static void runLaterDelayed(long delay, Runnable r) {
        new Thread(() -> {
            try {
                Thread.sleep(delay);
                FxHelper.runLater(r);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FxHelper.class.getName()).log(Level.SEVERE, null, ex);
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    public static void scrollToItemIfNotVisible(ListView<?> listview, Object item) {
        try {
            ListViewSkin listViewSkin = (ListViewSkin)listview.getSkin();
            VirtualFlow virtualFlow = (VirtualFlow)listViewSkin.getChildren().get(0);
            int firstIndex = virtualFlow.getFirstVisibleCell().getIndex();
            int lastIndex = virtualFlow.getLastVisibleCell().getIndex();
            int index = listview.getItems().indexOf(item);
            if (index < firstIndex || index > lastIndex) {
                listview.scrollTo(index);
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    public static void setDarkColor(javafx.scene.paint.Color darkColor) {
        sDarkColor = darkColor;
    }

    public static void setDarkThemeEnabled(boolean enabled) {
        System.setProperty("trixon.almond.fx.dark", String.valueOf(enabled));
    }

    public static void setEditable(boolean editable, Spinner ... spinners) {
        for (Spinner spinner : spinners) {
            spinner.setEditable(editable);
        }
    }

    public static void setMargin(Insets insets, Region ... regions) {
        for (Region region : regions) {
            GridPane.setMargin((Node)region, (Insets)insets);
        }
    }

    public static void setPadding(Insets insets, Region ... regions) {
        for (Region region : regions) {
            region.setPadding(insets);
        }
    }

    public static void setPrefWidth(double width, Region ... regions) {
        for (Region region : regions) {
            region.setPrefWidth(width);
        }
    }

    public static void setTooltip(Action action, KeyCodeCombination keyCodeCombination) {
        action.setLongText(FORMAT_TITLE_DESC.formatted(action.getText(), keyCodeCombination.getDisplayText()));
    }

    public static void setUIScale(double scale) {
        UI_SCALE = scale;
    }

    public static void setValignment(VPos value, Node ... nodes) {
        for (Node node : nodes) {
            GridPane.setValignment((Node)node, (VPos)value);
        }
    }

    public static Optional showAndWait(Dialog dialog, Stage stage) {
        Stage alertStage = (Stage)dialog.getDialogPane().getScene().getWindow();
        if (stage != null) {
            alertStage.setAlwaysOnTop(stage.isAlwaysOnTop());
        }
        alertStage.toFront();
        return dialog.showAndWait();
    }

    public static void slimToolBar(ToolBar toolBar) {
        toolBar.setStyle("-fx-spacing: 0px; -fx-background-insets: 0, 0 0 0 0;");
        toolBar.setPadding(Insets.EMPTY);
        toolBar.setBorder(Border.EMPTY);
    }

    public static void undecorateButton(ButtonBase buttonBase) {
        buttonBase.setStyle(STYLE_IDLE_BUTTON);
        buttonBase.setOnMouseEntered(e -> buttonBase.setStyle(STYLE_HOVERED_BUTTON));
        buttonBase.setOnMouseExited(e -> buttonBase.setStyle(STYLE_IDLE_BUTTON));
    }

    public static void undecorateButtons(Stream<Node> stream) {
        stream.filter(item -> item instanceof ButtonBase).map(item -> (ButtonBase)item).forEachOrdered(buttonBase -> FxHelper.undecorateButton(buttonBase));
    }

    public static void unloadDarkTheme(Scene scene) {
        FxHelper.runLater(() -> {
            FxHelper.setDarkThemeEnabled(false);
            scene.getStylesheets().remove((Object)FxHelper.class.getResource(DARCULA).toExternalForm());
        });
    }

    @Deprecated(forRemoval=true)
    public static void windowStateRestore(Stage stage, double defaultWidth, double defaultHeight, Class c) throws BackingStoreException {
        Preferences p = Preferences.userNodeForPackage(c);
        if (PrefsHelper.keyExists(p, STAGE_X) && PrefsHelper.keyExists(p, STAGE_Y) && PrefsHelper.keyExists(p, STAGE_H) && PrefsHelper.keyExists(p, STAGE_W)) {
            stage.setX(p.getDouble(STAGE_X, -1.0));
            stage.setY(p.getDouble(STAGE_Y, -1.0));
            stage.setWidth(p.getDouble(STAGE_W, -1.0));
            stage.setHeight(p.getDouble(STAGE_H, -1.0));
            stage.setAlwaysOnTop(p.getBoolean(STAGE_ALWAYS_ON_TOP, false));
            stage.setFullScreen(p.getBoolean(STAGE_FULL_SCREEN, false));
            stage.setMaximized(p.getBoolean(STAGE_MAXIMIZED, false));
        } else {
            stage.setWidth(defaultWidth);
            stage.setHeight(defaultHeight);
            stage.centerOnScreen();
        }
    }

    @Deprecated(forRemoval=true)
    public static void windowStateSave(Stage stage, Class c) {
        Preferences p = Preferences.userNodeForPackage(c);
        p.putDouble(STAGE_H, stage.getHeight());
        p.putDouble(STAGE_W, stage.getWidth());
        p.putDouble(STAGE_X, stage.getX());
        p.putDouble(STAGE_Y, stage.getY());
        p.putBoolean(STAGE_ALWAYS_ON_TOP, stage.isAlwaysOnTop());
        p.putBoolean(STAGE_FULL_SCREEN, stage.isFullScreen());
        p.putBoolean(STAGE_MAXIMIZED, stage.isMaximized());
    }
}

