/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.fx;

import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.scene.Node;
import javax.swing.JFrame;
import org.controlsfx.control.PopOver;

public class PopOverWatcher {
    private JFrame mFrame;
    private final LinkedHashMap<PopOver, Node> mPopOvers = new LinkedHashMap();

    public static PopOverWatcher getInstance() {
        return PopOverWatcherHolder.INSTANCE;
    }

    private PopOverWatcher() {
    }

    public void registerPopOver(PopOver popOver, Node node) {
        this.mPopOvers.remove(popOver);
        this.mPopOvers.put(popOver, node);
    }

    public void setFrame(JFrame frame) {
        this.mFrame = frame;
        this.mFrame.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                Platform.runLater(() -> {
                    for (Map.Entry<PopOver, Node> entry : PopOverWatcher.this.mPopOvers.entrySet()) {
                        entry.getKey().show(entry.getValue());
                    }
                });
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                Platform.runLater(() -> {
                    ArrayList<PopOver> popOvers = new ArrayList<PopOver>(PopOverWatcher.this.mPopOvers.keySet());
                    Collections.reverse(popOvers);
                    for (PopOver popOver : popOvers) {
                        if (popOver.isShowing()) {
                            popOver.hide();
                            continue;
                        }
                        PopOverWatcher.this.mPopOvers.keySet().remove(popOver);
                    }
                });
            }
        });
    }

    private static class PopOverWatcherHolder {
        private static final PopOverWatcher INSTANCE = new PopOverWatcher();

        private PopOverWatcherHolder() {
        }
    }
}

