/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.fx;

import java.net.URI;
import java.net.URISyntaxException;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import org.apache.commons.lang3.StringUtils;
import se.trixon.almond.util.MailHelper;
import se.trixon.almond.util.SystemHelper;

public class UriLabel
extends Hyperlink {
    private URI mUri;

    public UriLabel() {
        this.init();
    }

    public UriLabel(String text) {
        super(text);
        this.init();
    }

    public UriLabel(String text, Node graphic) {
        super(text, graphic);
        this.init();
    }

    public URI getUri() {
        return this.mUri;
    }

    public void setUri(URI uri) {
        this.mUri = uri;
    }

    public void setUri(String uriString) {
        try {
            this.mUri = new URI(uriString);
        }
        catch (URISyntaxException ex) {
            System.err.println(ex);
        }
    }

    private void init() {
        this.setOnAction(actionEvent -> {
            if (StringUtils.startsWith((CharSequence)this.mUri.getScheme(), (CharSequence)"http")) {
                SystemHelper.desktopBrowse(this.mUri.toString());
            } else {
                MailHelper.mail(this.mUri);
            }
        });
    }
}

