/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.fx.control;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import javafx.beans.property.SimpleObjectProperty;
import org.apache.commons.lang3.ObjectUtils;
import org.controlsfx.control.RangeSlider;

public class DateRangeSlider
extends RangeSlider {
    private final SimpleObjectProperty<LocalDate> mHighDateProperty = new SimpleObjectProperty();
    private final SimpleObjectProperty<LocalDate> mLowDateProperty = new SimpleObjectProperty();
    private final SimpleObjectProperty<LocalDate> mMaxDateProperty = new SimpleObjectProperty();
    private final SimpleObjectProperty<LocalDate> mMinDateProperty = new SimpleObjectProperty();

    public DateRangeSlider() {
        this.init();
        this.initListeners();
    }

    public LocalDate getHighDate() {
        return (LocalDate)this.mHighDateProperty.getValue();
    }

    public LocalDate getLowDate() {
        return (LocalDate)this.mLowDateProperty.getValue();
    }

    public LocalDate getMaxDate() {
        return (LocalDate)this.mMaxDateProperty.getValue();
    }

    public LocalDate getMinDate() {
        return (LocalDate)this.mMinDateProperty.getValue();
    }

    public SimpleObjectProperty<LocalDate> highDateProperty() {
        return this.mHighDateProperty;
    }

    public SimpleObjectProperty<LocalDate> lowDateProperty() {
        return this.mLowDateProperty;
    }

    public SimpleObjectProperty<LocalDate> maxDateProperty() {
        return this.mMaxDateProperty;
    }

    public SimpleObjectProperty<LocalDate> minDateProperty() {
        return this.mMinDateProperty;
    }

    public void setHighDate(LocalDate localDate) {
        this.mHighDateProperty.setValue((Object)localDate);
    }

    public void setLowDate(LocalDate localDate) {
        this.mLowDateProperty.setValue((Object)localDate);
    }

    public void setMaxDate(LocalDate localDate) {
        this.mMaxDateProperty.setValue((Object)localDate);
    }

    public void setMinDate(LocalDate localDate) {
        this.mMinDateProperty.setValue((Object)localDate);
    }

    public void setMinMaxDate(LocalDate minDate, LocalDate maxDate) {
        this.mMinDateProperty.setValue((Object)minDate);
        this.mMaxDateProperty.setValue((Object)maxDate);
        this.mLowDateProperty.setValue((Object)minDate);
        this.mHighDateProperty.setValue((Object)maxDate);
        this.setMin(0.0);
        if (ObjectUtils.allNotNull((Object[])new Object[]{minDate, maxDate})) {
            this.setMax(ChronoUnit.DAYS.between(minDate, maxDate));
        }
        this.setLowValue(this.getMin());
        this.setHighValue(this.getMax());
    }

    private void init() {
        this.setMajorTickUnit(7.0);
        this.setMinorTickCount(1);
    }

    private void initListeners() {
        this.lowValueProperty().addListener((ov, t, t1) -> {
            if (this.getMinDate() != null) {
                this.lowDateProperty().setValue((Object)this.getMinDate().plusDays(t1.intValue()));
            }
        });
        this.highValueProperty().addListener((ov, t, t1) -> {
            if (this.getMinDate() != null) {
                this.highDateProperty().setValue((Object)this.getMinDate().plusDays(t1.intValue()));
            }
        });
        this.lowDateProperty().addListener((ov, t, t1) -> {
            if (this.getMinDate() != null) {
                this.setLowValue(ChronoUnit.DAYS.between(this.getMinDate(), (Temporal)t1));
            }
        });
        this.highDateProperty().addListener((ov, t, t1) -> {
            if (this.getMaxDate() != null) {
                this.setHighValue(ChronoUnit.DAYS.between(this.getMinDate(), (Temporal)t1));
            }
        });
    }
}

