/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.fx.control;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.apache.commons.lang3.StringUtils;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;

public class FileChooserPane
extends BorderPane {
    private final Button mButton = new Button(null, (Node)new Glyph("FontAwesome", (Object)FontAwesome.Glyph.FOLDER_OPEN_ALT).size(FxHelper.getScaledFontSize() * 1.5));
    private final CheckBox mCheckBox = new CheckBox();
    private final DirectoryChooser mDirectoryChooser = new DirectoryChooser();
    private boolean mEnabledPathExpander = true;
    private final FileChooser mFileChooser = new FileChooser();
    private FileChooserListener mFileChooserListener;
    private final List<File> mFiles = new ArrayList<File>();
    private final Label mLabel = new Label();
    private ObjectMode mObjectMode = ObjectMode.DIRECTORY;
    private SelectionMode mSelectionMode = SelectionMode.SINGLE;
    private final TextField mTextField = new TextField();
    private String mTitle = Dict.OPEN.toString();

    public FileChooserPane() {
        this.init();
    }

    public FileChooserPane(String title) {
        this.init();
        this.mTitle = title;
    }

    public FileChooserPane(String title, String headerLabelText) {
        this.init();
        this.mTitle = title;
        this.setHeaderLabelText(headerLabelText);
    }

    public FileChooserPane(String title, ObjectMode objectMode, SelectionMode selectionMode) {
        this.init();
        this.mTitle = title;
        this.setSelectionMode(selectionMode);
        this.setObjectMode(objectMode);
    }

    public FileChooserPane(String title, ObjectMode objectMode, SelectionMode selectionMode, String checkBoxText) {
        this.init();
        this.mTitle = title;
        this.setSelectionMode(selectionMode);
        this.setObjectMode(objectMode);
        this.setHeaderCheckBoxText(checkBoxText);
    }

    public FileChooserPane(String title, String headerLabelText, ObjectMode objectMode, SelectionMode selectionMode) {
        this.init();
        this.mTitle = title;
        this.setHeaderLabelText(headerLabelText);
        this.setSelectionMode(selectionMode);
        this.setObjectMode(objectMode);
    }

    public void addFilter(FileChooser.ExtensionFilter filter) {
        this.mFileChooser.getExtensionFilters().add((Object)filter);
    }

    public void addFilters(FileChooser.ExtensionFilter ... filters) {
        this.mFileChooser.getExtensionFilters().addAll((Object[])filters);
    }

    public void clearFilters() {
        this.mFileChooser.getExtensionFilters().clear();
    }

    public Button getButton() {
        return this.mButton;
    }

    public CheckBox getCheckBox() {
        return this.mCheckBox;
    }

    public DirectoryChooser getDirectoryChooser() {
        return this.mDirectoryChooser;
    }

    public FileChooser getFileChooser() {
        return this.mFileChooser;
    }

    public FileChooser.ExtensionFilter getFilter() {
        return this.mFileChooser.getSelectedExtensionFilter();
    }

    public Label getLabel() {
        return this.mLabel;
    }

    public ObjectMode getObjectMode() {
        return this.mObjectMode;
    }

    public File getPath() {
        return new File(this.getPathAsString());
    }

    public String getPathAsString() {
        return this.mTextField.getText();
    }

    public File[] getPaths() {
        String[] pathStrings = StringUtils.split((String)this.mTextField.getText(), (String)File.pathSeparator);
        File[] paths = new File[pathStrings.length];
        for (int i = 0; i < pathStrings.length; ++i) {
            paths[i] = new File(pathStrings[i]);
        }
        return paths;
    }

    public SelectionMode getSelectionMode() {
        return this.mSelectionMode;
    }

    public TextField getTextField() {
        return this.mTextField;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public boolean isEnabledPathExpander() {
        return this.mEnabledPathExpander;
    }

    public void setEnabledPathExpander(boolean enabledPathExpander) {
        this.mEnabledPathExpander = enabledPathExpander;
    }

    public void setFileChooserListener(FileChooserListener fileChooserListener) {
        this.mFileChooserListener = fileChooserListener;
    }

    public void setFilter(FileChooser.ExtensionFilter filter) {
        this.mFileChooser.setSelectedExtensionFilter(filter);
    }

    public void setGraphic(Node value) {
        this.mButton.setGraphic(value);
    }

    public void setHeaderCheckBoxText(String value) {
        this.setTop((Node)this.mCheckBox);
        this.mCheckBox.setText(value);
        this.mTextField.disableProperty().bind((ObservableValue)this.mCheckBox.selectedProperty().not());
        this.mButton.disableProperty().bind((ObservableValue)this.mCheckBox.selectedProperty().not());
    }

    public void setHeaderLabelText(String value) {
        this.setTop((Node)this.mLabel);
        this.mLabel.setText(value);
    }

    public void setObjectMode(ObjectMode objectMode) {
        this.mObjectMode = objectMode;
        if (this.mObjectMode == ObjectMode.DIRECTORY) {
            this.mSelectionMode = SelectionMode.SINGLE;
        }
    }

    public void setPath(String path) {
        this.mTextField.setText(path);
    }

    public void setPath(File path) {
        try {
            this.mTextField.setText(path.getPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSelected(boolean selected) {
        this.mCheckBox.setSelected(selected);
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        this.mSelectionMode = selectionMode;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    private void init() {
        this.setCenter((Node)this.mTextField);
        this.setRight((Node)this.mButton);
        FxHelper.undecorateButton((ButtonBase)this.mButton);
        this.mButton.setTooltip(new Tooltip(Dict.SELECT.toString()));
        this.mTextField.setOnAction(actionEvent -> {
            if (this.mEnabledPathExpander) {
                File file = new File(this.mTextField.getText().trim());
                this.setPath(file.getAbsolutePath());
                try {
                    this.mFileChooserListener.onFileChooserOk(this, file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.setOnDragOver(dragEvent -> {
            Dragboard dragboard = dragEvent.getDragboard();
            if (dragboard.hasFiles()) {
                dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            }
        });
        this.setOnDragDropped(dragEvent -> {
            this.populateValidatedFileList(dragEvent.getDragboard().getFiles());
            try {
                if (!this.mFiles.isEmpty()) {
                    if (this.mSelectionMode == SelectionMode.MULTIPLE) {
                        this.mFileChooserListener.onFileChooserDrop(this, this.mFiles);
                    } else {
                        this.mFileChooserListener.onFileChooserDrop(this, this.mFiles.get(0));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.mButton.setOnAction(actionEvent -> {
            try {
                this.mFileChooserListener.onFileChooserPreSelect(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Window window = this.mButton.getScene().getWindow();
            boolean cancelled = true;
            if (this.mObjectMode == ObjectMode.DIRECTORY) {
                this.mDirectoryChooser.setTitle(this.mTitle);
                this.setInitialDirectory(this.mDirectoryChooser);
                File file = this.mDirectoryChooser.showDialog(window);
                if (file != null) {
                    this.populateValidatedFileList(Arrays.asList(file));
                }
                cancelled = file == null;
            } else {
                this.mFileChooser.setTitle(this.mTitle);
                this.setInitialDirectory(this.mFileChooser);
                if (this.mSelectionMode == SelectionMode.MULTIPLE) {
                    List files = this.mFileChooser.showOpenMultipleDialog(window);
                    boolean bl = cancelled = files == null;
                    if (!cancelled) {
                        this.populateValidatedFileList(files);
                    }
                } else {
                    File file = this.mFileChooser.showOpenDialog(window);
                    if (file != null) {
                        this.populateValidatedFileList(Arrays.asList(file));
                    }
                    cancelled = file == null;
                }
            }
            try {
                if (cancelled) {
                    this.mFileChooserListener.onFileChooserCancel(this);
                } else if (this.mSelectionMode == SelectionMode.MULTIPLE) {
                    this.mFileChooserListener.onFileChooserOk(this, this.mFiles);
                } else {
                    this.mFileChooserListener.onFileChooserOk(this, this.mFiles.get(0));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.mCheckBox.setOnAction(actionEvent -> {
            try {
                this.mFileChooserListener.onFileChooserCheckBoxChange(this, this.mCheckBox.isSelected());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        FxHelper.setPadding(FxHelper.getUIScaledInsets(0.0, 0.0, 4.0, 0.0), new Region[]{this.mLabel, this.mCheckBox});
    }

    private void populateValidatedFileList(List<File> files) {
        this.mFiles.clear();
        ArrayList mFileStrings = new ArrayList();
        files.stream().filter(file -> file.isDirectory() && this.mObjectMode == ObjectMode.DIRECTORY || file.isFile() && this.mObjectMode == ObjectMode.FILE).forEachOrdered(file -> {
            this.mFiles.add((File)file);
            mFileStrings.add(file.getPath());
        });
        String sum = null;
        if (this.mSelectionMode == SelectionMode.MULTIPLE) {
            sum = String.join((CharSequence)File.pathSeparator, mFileStrings);
        } else if (!mFileStrings.isEmpty()) {
            sum = (String)mFileStrings.get(0);
        }
        this.mTextField.setText(sum);
    }

    private void setInitialDirectory(DirectoryChooser chooser) {
        try {
            String firstPath = StringUtils.split((String)this.mTextField.getText(), (char)File.pathSeparatorChar)[0];
            File f = new File(firstPath);
            if (f.isDirectory()) {
                chooser.setInitialDirectory(f);
            } else if (f.isFile()) {
                chooser.setInitialDirectory(f.getParentFile());
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void setInitialDirectory(FileChooser chooser) {
        try {
            String firstPath = StringUtils.split((String)this.mTextField.getText(), (char)File.pathSeparatorChar)[0];
            File f = new File(firstPath);
            if (f.isFile()) {
                chooser.setInitialDirectory(f.getParentFile());
                chooser.setInitialFileName(f.getName());
            }
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    public static enum ObjectMode {
        DIRECTORY,
        FILE;

    }

    public static interface FileChooserListener {
        public void onFileChooserCancel(FileChooserPane var1);

        public void onFileChooserCheckBoxChange(FileChooserPane var1, boolean var2);

        public void onFileChooserDrop(FileChooserPane var1, File var2);

        public void onFileChooserDrop(FileChooserPane var1, List<File> var2);

        public void onFileChooserOk(FileChooserPane var1, File var2);

        public void onFileChooserOk(FileChooserPane var1, List<File> var2);

        public void onFileChooserPreSelect(FileChooserPane var1);
    }
}

