/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.fx.dialogs;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.stage.Window;
import org.apache.commons.lang3.StringUtils;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.OptionsBase;
import se.trixon.almond.util.fx.FxHelper;

public class OptionalDialog {
    private static final Options sOptions = new Options();

    public static boolean requestShowDialog(Class cls, String id, Alert.AlertType alertType, Window window, String title, String headerText, String message, String checkBoxText) {
        String key = cls.getName() + "_" + id;
        if (sOptions.is(key, true)) {
            Label label = new Label(message);
            label.setAlignment(Pos.TOP_LEFT);
            BorderPane borderPane = new BorderPane((Node)label);
            label.prefHeightProperty().bind((ObservableValue)borderPane.heightProperty());
            label.prefWidthProperty().bind((ObservableValue)borderPane.widthProperty());
            CheckBox checkBox = new CheckBox(StringUtils.defaultString((String)checkBoxText, (String)Dict.SHOW_THIS_AGAIN.toString()));
            checkBox.setSelected(true);
            FxHelper.setPadding(new Insets(16.0, 0.0, 0.0, 16.0), new Region[]{checkBox});
            borderPane.setBottom((Node)checkBox);
            Alert alert = new Alert(alertType);
            alert.initOwner(window);
            alert.setTitle(title);
            alert.setHeaderText(headerText);
            alert.getDialogPane().setContent((Node)borderPane);
            alert.setResizable(true);
            alert.showAndWait();
            sOptions.put(key, checkBox.isSelected());
            return true;
        }
        return false;
    }

    public static void reset(String key) {
        sOptions.put(key, true);
    }

    public static void resetAll() {
        try {
            sOptions.getPreferences().clear();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(OptionalDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void setPreferences(Preferences preferences) {
        sOptions.setPreferences(preferences.node("optionalDialogState"));
    }

    static {
        OptionalDialog.setPreferences(Preferences.userNodeForPackage(OptionalDialog.class));
    }

    public static class Options
    extends OptionsBase {
    }
}

