/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.fx.dialogs;

import java.io.File;
import java.util.HashMap;
import java.util.Optional;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.io.FilenameUtils;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;

public class SimpleDialog {
    private static final HashMap<String, FileChooser.ExtensionFilter> sExtensionFilters = new HashMap();
    private static final FileChooser sFileChooser = new FileChooser();
    private static FileChooser.ExtensionFilter sFilter;
    private static Window sOwner;
    private static File sPath;
    private static File[] sPaths;
    private static String sTitle;

    public static void addFilter(FileChooser.ExtensionFilter filter) {
        sFileChooser.getExtensionFilters().add((Object)filter);
    }

    public static void addFilters(String ... filters) {
        for (String filter : filters) {
            SimpleDialog.addFilter(sExtensionFilters.get(filter));
        }
    }

    public static void clearFilters() {
        sFileChooser.getExtensionFilters().clear();
    }

    public static HashMap<String, FileChooser.ExtensionFilter> getExtensionFilters() {
        return sExtensionFilters;
    }

    public static FileChooser.ExtensionFilter getFilter() {
        return sFilter;
    }

    public static Window getOwner() {
        return sOwner;
    }

    public static File getPath() {
        return sPath;
    }

    public static File[] getPaths() {
        return sPaths;
    }

    public static String getTitle() {
        return sTitle;
    }

    public static boolean openFile() {
        File file = sFileChooser.showOpenDialog(sOwner);
        if (null == file) {
            return false;
        }
        sPath = file;
        return true;
    }

    public static boolean saveFile(String ... extensions) {
        File file = sFileChooser.showSaveDialog(sOwner);
        if (null == file) {
            return false;
        }
        boolean fileExistsAlreadyConfirmed = file.isFile();
        if (extensions != null && extensions.length > 0) {
            String fileExt = FilenameUtils.getExtension((String)file.getName());
            boolean validExt = false;
            for (String extension : extensions) {
                if (!fileExt.toLowerCase().equalsIgnoreCase(extension)) continue;
                validExt = true;
                break;
            }
            if (!validExt) {
                Object suffix = file.getName().endsWith(".") ? extensions[0] : "." + extensions[0];
                file = new File(file.getAbsolutePath() + (String)suffix);
            }
        }
        if (file.exists() && !fileExistsAlreadyConfirmed) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.initOwner(sOwner);
            alert.setTitle(Dict.Dialog.TITLE_FILE_EXISTS.toString());
            alert.setHeaderText(Dict.Dialog.MESSAGE_FILE_EXISTS.toString().formatted(file.getAbsolutePath()));
            ButtonType replaceButtonType = new ButtonType(Dict.REPLACE.toString(), ButtonBar.ButtonData.YES);
            ButtonType cancelButtonType = new ButtonType(Dict.CANCEL.toString(), ButtonBar.ButtonData.NO);
            alert.getButtonTypes().setAll((Object[])new ButtonType[]{replaceButtonType, cancelButtonType});
            Optional result = FxHelper.showAndWait((Dialog)alert, (Stage)sOwner);
            if (result.isPresent() && result.get() == cancelButtonType) {
                return SimpleDialog.saveFile(new String[0]);
            }
        }
        sPath = file;
        return true;
    }

    public static void setFilter(String filterExt) {
        SimpleDialog.setFilter(sExtensionFilters.get(filterExt));
    }

    public static void setFilter(FileChooser.ExtensionFilter filter) {
        sFilter = filter;
        sFileChooser.setSelectedExtensionFilter(filter);
    }

    public static void setOwner(Window owner) {
        sOwner = owner;
    }

    public static void setPath(File path) {
        sPath = path;
        sFileChooser.setInitialDirectory(path);
    }

    public static void setSelectedFile(File file) {
        SimpleDialog.setSelectedFile(file.getName());
    }

    public static void setSelectedFile(String filename) {
        sFileChooser.setInitialFileName(filename);
    }

    public static void setTitle(String title) {
        sTitle = title;
        sFileChooser.setTitle(title);
    }

    private SimpleDialog() {
    }

    static {
        sPaths = new File[0];
    }
}

