/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.fx.dialogs.about;

import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TabPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.controlsfx.control.action.Action;
import se.trixon.almond.util.AboutModel;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.fx.dialogs.about.AboutTab;
import se.trixon.almond.util.fx.dialogs.about.AuthorsTab;
import se.trixon.almond.util.fx.dialogs.about.LibrariesTab;
import se.trixon.almond.util.fx.dialogs.about.PropertiesTab;
import se.trixon.almond.util.fx.dialogs.about.ThanksToTab;
import se.trixon.almond.util.fx.dialogs.about.TranslationTab;

public class AboutPane
extends TabPane {
    private final AboutModel mAboutModel;

    public static Action getAction(Stage stage, AboutModel aboutModel) {
        AboutPane aboutPane = new AboutPane(aboutModel);
        Action action = new Action(Dict.ABOUT.toString(), actionEvent -> {
            aboutPane.reset();
            Alert alert = new Alert(Alert.AlertType.NONE);
            alert.initOwner((Window)stage);
            alert.setTitle(Dict.ABOUT_S.toString().formatted(aboutModel.getAppName()));
            ButtonType closeButtonType = new ButtonType(Dict.CLOSE.toString(), ButtonBar.ButtonData.OK_DONE);
            alert.getButtonTypes().setAll((Object[])new ButtonType[]{closeButtonType});
            alert.setGraphic((Node)((ImageView)aboutModel.getLogo()));
            alert.setHeaderText(" ");
            alert.setResizable(true);
            DialogPane dialogPane = alert.getDialogPane();
            dialogPane.setContent((Node)aboutPane);
            dialogPane.setPrefSize((double)FxHelper.getUIScaled(520), (double)FxHelper.getUIScaled(400));
            for (Node node : dialogPane.getChildren()) {
                if (!(node instanceof GridPane)) continue;
                GridPane gridPane = (GridPane)node;
                Label appLabel = new Label(aboutModel.getAppName());
                double scaledFontSize = FxHelper.getScaledFontSize();
                appLabel.setFont(new Font(scaledFontSize * 1.8));
                Label verLabel = new Label("%s %s".formatted(Dict.VERSION.toString(), aboutModel.getAppVersion()));
                verLabel.setFont(new Font(scaledFontSize * 1.2));
                Label dateLabel = new Label(aboutModel.getAppDate());
                dateLabel.setFont(new Font(scaledFontSize * 1.2));
                VBox box = new VBox(new Node[]{appLabel, verLabel, dateLabel});
                box.setAlignment(Pos.CENTER_LEFT);
                gridPane.add((Node)box, 0, 0);
                break;
            }
            FxHelper.applyFontScale(dialogPane.getScene());
            FxHelper.showAndWait((Dialog)alert, stage);
        });
        return action;
    }

    public AboutPane(AboutModel aboutModel) {
        this.mAboutModel = aboutModel;
        this.init();
    }

    public void reset() {
        this.getTabs().stream().filter(tab -> tab instanceof ResetableTab).forEachOrdered(tab -> ((ResetableTab)tab).reset());
        this.getSelectionModel().selectFirst();
    }

    private void init() {
        this.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.getTabs().add((Object)new AboutTab(this.mAboutModel));
        this.getTabs().add((Object)new LibrariesTab(this.mAboutModel));
        if (this.mAboutModel.getAuthors() != null) {
            this.getTabs().add((Object)new AuthorsTab(this.mAboutModel));
        }
        if (this.mAboutModel.getTranslation() != null) {
            this.getTabs().add((Object)new TranslationTab(this.mAboutModel));
        }
        if (this.mAboutModel.getTranslation() != null) {
            this.getTabs().add((Object)new ThanksToTab(this.mAboutModel));
        }
        this.getTabs().add((Object)new PropertiesTab(this.mAboutModel));
    }

    public static interface ResetableTab {
        public void reset();
    }
}

