/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.fx.dialogs.about;

import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;
import org.apache.commons.lang3.StringUtils;
import se.trixon.almond.util.AboutModel;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.SystemHelper;
import se.trixon.almond.util.fx.dialogs.about.AboutPane;

public class PropertiesTab
extends Tab
implements AboutPane.ResetableTab {
    private ContextMenu mContextMenu;
    private final ObservableList<SystemProperty> mData = FXCollections.observableArrayList();
    private int mMaxKeyLength = 0;
    private final TableView<SystemProperty> mTableView = new TableView();

    public PropertiesTab(AboutModel aboutModel) {
        this.setText(Dict.PROPERTIES.toString());
        this.init();
        this.setContent((Node)this.mTableView);
    }

    @Override
    public void reset() {
        this.mTableView.scrollTo(0);
    }

    private void init() {
        this.initSystemProperties();
        TableColumn keyCol = new TableColumn(Dict.KEY.toString());
        keyCol.setCellValueFactory((Callback)new PropertyValueFactory("key"));
        keyCol.setSortable(false);
        keyCol.prefWidthProperty().bind((ObservableValue)this.mTableView.widthProperty().multiply(0.3));
        TableColumn valCol = new TableColumn(Dict.VALUE.toString());
        valCol.setCellValueFactory((Callback)new PropertyValueFactory("val"));
        valCol.setSortable(false);
        valCol.prefWidthProperty().bind((ObservableValue)this.mTableView.widthProperty().multiply(0.65));
        this.mTableView.setItems(this.mData);
        this.mTableView.getColumns().add((Object)keyCol);
        this.mTableView.getColumns().add((Object)valCol);
        this.mContextMenu = new ContextMenu();
        MenuItem copyMenuItem = new MenuItem(Dict.COPY.toString());
        copyMenuItem.setOnAction(event -> {
            StringBuilder builder = new StringBuilder();
            this.mData.forEach(p -> builder.append(StringUtils.rightPad((String)p.getKey(), (int)(this.mMaxKeyLength + 2))).append(p.getVal()).append("\n"));
            SystemHelper.copyToClipboard(builder.toString());
        });
        this.mContextMenu.getItems().add((Object)copyMenuItem);
        this.mTableView.setContextMenu(this.mContextMenu);
    }

    private void initSystemProperties() {
        String[] keys;
        for (String key : keys = new String[]{"user.country", "user.home", "user.language", "user.name", "user.timezone", "", "os.arch", "os.name", "os.version", "", "file.encoding.pkg", "file.encoding", "file.separator", "path.separator", "", "netbeans.home", "netbeans.user", "netbeans.dirs", "netbeans.running.environment", "netbeans.productversion", "netbeans.buildnumber", "netbeans.dynamic.classpath", "netbeans.logger.console", "", "java.awt.graphicsenv", "java.awt.printerjob", "java.class.path", "java.class.version", "java.endorsed.dirs", "java.ext.dirs", "java.home", "java.io.tmpdir", "java.library.path", "java.runtime.name", "java.runtime.version", "java.specification.name", "java.specification.vendor", "java.specification.version", "java.vendor", "java.vendor.url.bug", "java.vendor.url", "java.version", "java.vm.info", "java.vm.name", "java.vm.specification.name", "java.vm.specification.vendor", "java.vm.specification.version", "java.vm.vendor", "java.vm.version", "", "sun.arch.data.model", "sun.boot.class.path", "sun.boot.library.path", "sun.cpu.endian", "sun.cpu.isalist", "sun.io.unicode.encoding", "sun.java.launcher", "sun.jnu.encoding", "sun.management.compiler", "sun.os.patch.level"}) {
            SystemProperty p = new SystemProperty(key);
            if (p.getKey().isEmpty() != p.getVal().isEmpty()) continue;
            this.mData.add((Object)p);
        }
    }

    public class SystemProperty {
        private final SimpleStringProperty mKey;
        private final SimpleStringProperty mVal;

        private SystemProperty(String key, String val) {
            this.mKey = new SimpleStringProperty(key);
            this.mVal = new SimpleStringProperty(val);
        }

        private SystemProperty(String key) {
            this.mKey = new SimpleStringProperty(key);
            this.mVal = new SimpleStringProperty("");
            PropertiesTab.this.mMaxKeyLength = Math.max(PropertiesTab.this.mMaxKeyLength, key.length());
            if (!key.isEmpty() && System.getProperties().keySet().contains(key)) {
                this.setVal(System.getProperty(key));
            }
        }

        public String getKey() {
            return this.mKey.get();
        }

        public String getVal() {
            return this.mVal.get();
        }

        public void setKey(String key) {
            this.mKey.set(key);
        }

        public void setVal(String val) {
            this.mVal.set(val);
        }
    }
}

