/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.io;

import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public abstract class CoordinateFile {
    protected Charset mCharset = StandardCharsets.UTF_8;
    protected String mLineEnding = "\r\n";
    protected Path mPath;
    protected final Path2D.Double mPath2D = new Path2D.Double();
    protected BufferedReader mReader;
    protected int mValuePrecision = 8;
    protected BufferedWriter mWriter;
    protected int mXYPrecision = 8;

    public void closeWriter() throws IOException {
        this.mWriter.close();
    }

    public Rectangle2D getBounds2D() {
        return this.mPath2D.getBounds2D();
    }

    public Charset getCharset() {
        return this.mCharset;
    }

    public File getFile() {
        return this.mPath.toFile();
    }

    public String getLineEnding() {
        return this.mLineEnding;
    }

    public Path getPath() {
        return this.mPath;
    }

    public Path2D.Double getPath2D() {
        return this.mPath2D;
    }

    public int getValuePrecision() {
        return this.mValuePrecision;
    }

    public int getXYPrecision() {
        return this.mXYPrecision;
    }

    public abstract boolean isValid(File var1);

    public void openWriter(File file) throws IOException {
        this.mWriter = Files.newBufferedWriter(file.toPath(), this.mCharset, new OpenOption[0]);
    }

    public void setCharset(Charset charset) {
        this.mCharset = charset;
    }

    public void setLineEnding(String lineEnding) {
        this.mLineEnding = lineEnding;
    }

    public void setValuePrecision(int valuePrecision) {
        this.mValuePrecision = valuePrecision;
    }

    public void setXYPrecision(int XYPrecision) {
        this.mXYPrecision = XYPrecision;
    }
}

