/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.io;

import java.awt.geom.IllegalPathStateException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import se.trixon.almond.util.io.CoordinateFile;
import se.trixon.almond.util.io.CoordinateFormat;
import se.trixon.almond.util.io.GeoHeader;
import se.trixon.almond.util.io.GeoHelper;
import se.trixon.almond.util.io.GeoLine;
import se.trixon.almond.util.io.GeoPoint;

public class Geo
extends CoordinateFile {
    public static final String LINE_ENDING = "\r\n";
    public static final String NO_NEXT_SECTION = "DONOTBREAKONTHISSTOPSTRING";
    private LinkedHashMap<String, String> mAttributes = new LinkedHashMap();
    private CoordinateFormat mCoordinateFormat = CoordinateFormat.FORMATTED;
    private GeoHeader mHeader;
    private LinkedList<GeoLine> mLines = new LinkedList();
    private LinkedList<GeoPoint> mPoints = new LinkedList();
    private LinkedList<String> mRawLines;

    public Geo() {
        GeoPoint.setLineEnding(LINE_ENDING);
    }

    public Geo(GeoHeader geoHeader) {
        this.setHeader(geoHeader);
    }

    public void addPoint(GeoPoint geoPoint) {
        if (ObjectUtils.allNotNull((Object[])new Object[]{geoPoint, geoPoint.getX(), geoPoint.getY()})) {
            try {
                this.mPath2D.lineTo(geoPoint.getY(), geoPoint.getX());
            }
            catch (IllegalPathStateException e) {
                this.mPath2D.moveTo(geoPoint.getY(), geoPoint.getX());
            }
        }
        this.mPoints.add(geoPoint);
    }

    public LinkedHashMap<String, String> getAttributes() {
        return this.mAttributes;
    }

    public CoordinateFormat getCoordinateFormat() {
        return this.mCoordinateFormat;
    }

    public GeoHeader getHeader() {
        return this.mHeader;
    }

    public List<GeoLine> getLines() {
        return this.mLines;
    }

    public List<GeoPoint> getPoints() {
        return this.mPoints;
    }

    @Override
    public boolean isValid(File file) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void read(File file) throws IOException {
        this.mRawLines = new LinkedList(FileUtils.readLines((File)file, (Charset)this.mCharset));
        String[] elements = StringUtils.split((String)this.mRawLines.peek(), (String)",");
        if (elements.length < 3 || !StringUtils.containsIgnoreCase((CharSequence)elements[2], (CharSequence)"UTF-8")) {
            this.mCharset = StandardCharsets.ISO_8859_1;
            this.mRawLines = new LinkedList(FileUtils.readLines((File)file, (Charset)this.mCharset));
        }
        this.read();
    }

    public void read(String string) throws IOException {
        this.mRawLines = new LinkedList<String>(Arrays.asList(StringUtils.split((String)string, (String)LINE_ENDING)));
        this.read();
    }

    public void setAttributes(LinkedHashMap<String, String> attributes) {
        this.mAttributes = attributes;
    }

    public void setCoordinateFormat(CoordinateFormat coordinateFormat) {
        this.mCoordinateFormat = coordinateFormat;
    }

    public void setHeader(GeoHeader header) {
        this.mHeader = header;
    }

    @Override
    public void setLineEnding(String lineEnding) {
        super.setLineEnding(lineEnding);
        GeoPoint.setLineEnding(lineEnding);
    }

    public void setLines(LinkedList<GeoLine> lines) {
        this.mLines = lines;
    }

    public void setPoints(LinkedList<GeoPoint> points) {
        this.mPoints = points;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.mHeader.toStringBuilder());
        sb.append((CharSequence)GeoHelper.pointListToStringBuilder(this, this.mPoints, 0));
        sb.append((CharSequence)GeoHelper.lineListToStringBuilder(this, this.mLines));
        sb.append((CharSequence)GeoHelper.attributeListToStringBuilder(this.mAttributes, 0));
        return sb.toString();
    }

    public void write(GeoPoint geoPoint) throws IOException {
        this.mWriter.write(geoPoint.toString());
    }

    public void write(File file) throws IOException {
        this.write(file, CoordinateFormat.FORMATTED);
    }

    public void write(File file, CoordinateFormat coordinateFormat) throws IOException {
        this.mCoordinateFormat = coordinateFormat;
        FileUtils.writeStringToFile((File)file, (String)this.toString(), (Charset)this.mCharset);
    }

    private void read() throws IOException {
        LinkedList<String> section;
        LinkedList<String> headerSection = GeoHelper.extractSection("FileHeader", "PointList", this.mRawLines);
        this.mHeader = new GeoHeader(headerSection);
        try {
            section = GeoHelper.extractSection("PointList", "LineList", this.mRawLines);
            LinkedList<GeoPoint> points = GeoHelper.parsePointList(null, section);
            this.mPoints.addAll(points);
        }
        catch (Exception e) {
            throw new IOException("Parse PointList Failed: ", e);
        }
        try {
            section = GeoHelper.extractSection("LineList", "AttributeList", this.mRawLines);
            GeoHelper.stripWrapper(section);
            while (!section.isEmpty()) {
                LinkedList<String> lineSection = GeoHelper.extractSection("Line", NO_NEXT_SECTION, section);
                this.mLines.add(new GeoLine(lineSection));
            }
        }
        catch (Exception e) {
            throw new IOException("Parse LineList Failed: ", e);
        }
        try {
            section = GeoHelper.extractSection("AttributeList", NO_NEXT_SECTION, this.mRawLines);
            this.mAttributes.putAll(GeoHelper.getAttributes(section));
        }
        catch (Exception e) {
            throw new IOException("Parse AttributeList Failed: ", e);
        }
    }
}

