/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.io;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import se.trixon.almond.util.io.GeoHelper;

public class GeoHeader {
    private String mFileHeader;
    private final LinkedHashMap<String, String> mFileInfos = new LinkedHashMap();

    public GeoHeader() {
    }

    public GeoHeader(String fileHeader) {
        this.mFileHeader = "FileHeader " + fileHeader;
    }

    public GeoHeader(String fileHeader, LinkedHashMap<String, String> map) {
        this.mFileHeader = "FileHeader " + fileHeader;
        this.mFileInfos.putAll(map);
    }

    public GeoHeader(LinkedHashMap<String, String> map) {
        this("\"SBG Object Text v2.01\",\"Coordinate Document\",\"UTF-8\"", map);
    }

    public GeoHeader(LinkedList<String> lines) {
        this.mFileHeader = lines.get(0);
        for (String line : lines) {
            if (StringUtils.startsWithIgnoreCase((CharSequence)line, (CharSequence)"FileHeader") || StringUtils.equalsAny((CharSequence)line.trim(), (CharSequence[])new CharSequence[]{"begin", "end"})) continue;
            String[] keyVal = GeoHelper.getKeyVal(line);
            this.mFileInfos.put(keyVal[0], keyVal[1]);
        }
    }

    public String get(String key) {
        return this.mFileInfos.get(key);
    }

    public void put(String key, String value) {
        this.mFileInfos.put(key, value);
    }

    public String toString() {
        return this.toStringBuilder().toString();
    }

    public StringBuilder toStringBuilder() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mFileHeader).append("\r\n");
        sb.append("begin").append("\r\n");
        for (Map.Entry<String, String> entry : this.mFileInfos.entrySet()) {
            String value = GeoHelper.toQuotedString(entry.getValue());
            sb.append("\tFileInfo \"%s\",%s".formatted(entry.getKey(), value)).append("\r\n");
        }
        sb.append("end").append("\r\n");
        return sb;
    }
}

