/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.io;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import se.trixon.almond.util.io.Geo;
import se.trixon.almond.util.io.GeoLine;
import se.trixon.almond.util.io.GeoPoint;

public class GeoHelper {
    public static final String KEY_BEGIN = "begin";
    public static final String KEY_END = "end";

    static StringBuilder attributeListToStringBuilder(LinkedHashMap<String, String> attributes, int indentLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t".repeat(indentLevel)).append("AttributeList ").append("\r\n");
        if (!attributes.isEmpty()) {
            sb.append("\t".repeat(indentLevel)).append(KEY_BEGIN).append("\r\n");
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                sb.append("\t".repeat(indentLevel + 1)).append("Attribute \"%s\",\"%s\"".formatted(entry.getKey(), entry.getValue())).append("\r\n");
            }
            sb.append("\t".repeat(indentLevel)).append(KEY_END).append("\r\n");
        }
        return sb;
    }

    static LinkedList<String> extractSection(String sectionHeader, String nextSectionHeader, LinkedList<String> lines) {
        int rowCounter = 0;
        int open = 0;
        boolean hitSection = false;
        for (String line : lines) {
            if (hitSection && StringUtils.startsWithIgnoreCase((CharSequence)line.trim(), (CharSequence)sectionHeader)) break;
            ++rowCounter;
            if (hitSection) {
                if (line.trim().equalsIgnoreCase(KEY_BEGIN)) {
                    ++open;
                } else if (line.trim().equalsIgnoreCase(KEY_END)) {
                    --open;
                }
                if (open >= 1 && (!StringUtils.startsWithIgnoreCase((CharSequence)line.stripTrailing(), (CharSequence)nextSectionHeader) || !hitSection)) continue;
                break;
            }
            if (!StringUtils.startsWithIgnoreCase((CharSequence)line.strip(), (CharSequence)sectionHeader)) continue;
            hitSection = true;
        }
        if (open < 0) {
            --rowCounter;
        }
        boolean addEmptyBlock = false;
        LinkedList<String> section = new LinkedList<String>(lines.subList(0, rowCounter));
        if (StringUtils.startsWith((CharSequence)((CharSequence)section.peekLast()), (CharSequence)nextSectionHeader)) {
            lines.addFirst((String)section.pollLast());
            addEmptyBlock = true;
        } else if (rowCounter == 1) {
            addEmptyBlock = true;
        }
        if (addEmptyBlock) {
            section.add(KEY_BEGIN);
            section.add(KEY_END);
        }
        if (open < 0) {
            ++rowCounter;
        }
        GeoHelper.removeHead(lines, rowCounter);
        return section;
    }

    static LinkedHashMap<String, String> getAttributes(LinkedList<String> section) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        if (section.size() > 2) {
            GeoHelper.stripWrapper(section);
            for (String line : section) {
                line = StringUtils.removeStart((String)line.trim(), (String)"Attribute");
                String[] segments = StringUtils.splitPreserveAllTokens((String)line.trim(), (String)",");
                attributes.put(StringUtils.remove((String)segments[0], (String)"\""), StringUtils.remove((String)segments[1], (String)"\""));
            }
        }
        return attributes;
    }

    static String[] getKeyVal(String line) {
        int a = StringUtils.indexOf((CharSequence)line, (int)34, (int)0);
        int b = StringUtils.indexOf((CharSequence)line, (int)34, (int)(a + 1));
        int c = StringUtils.indexOf((CharSequence)line, (int)34, (int)(b + 1));
        int d = StringUtils.indexOf((CharSequence)line, (int)34, (int)(c + 1));
        String key = StringUtils.substring((String)line, (int)(a + 1), (int)b);
        String val = "";
        if (c > b) {
            val = StringUtils.substring((String)line, (int)(c + 1), (int)d);
        }
        return new String[]{key, val};
    }

    static StringBuilder lineListToStringBuilder(Geo geo, LinkedList<GeoLine> geoLines) {
        StringBuilder sb = new StringBuilder();
        sb.append("LineList ").append("\r\n");
        if (!geoLines.isEmpty()) {
            sb.append(KEY_BEGIN).append("\r\n");
            for (GeoLine geoLine : geoLines) {
                geoLine.setGeo(geo);
                sb.append("\t".repeat(1)).append(geoLine.toString());
            }
            sb.append(KEY_END).append("\r\n");
        }
        return sb;
    }

    static LinkedList<GeoPoint> parsePointList(GeoLine geoLine, LinkedList<String> pointsSection) {
        GeoHelper.stripWrapper(pointsSection);
        LinkedList<GeoPoint> points = new LinkedList<GeoPoint>();
        while (!pointsSection.isEmpty()) {
            String s;
            LinkedList<String> pointSection = GeoHelper.extractSection("Point ", "Point", pointsSection);
            String key = pointSection.peek().trim();
            if (key.startsWith("Point ")) {
                points.add(new GeoPoint(pointSection));
                continue;
            }
            if (!key.startsWith("AttributeList") || geoLine == null) continue;
            if (!pointSection.peekLast().trim().equalsIgnoreCase(KEY_END) && StringUtils.containsIgnoreCase((CharSequence)(s = String.join((CharSequence)"\n", pointSection)), (CharSequence)"AttributeList") && StringUtils.containsIgnoreCase((CharSequence)s, (CharSequence)KEY_BEGIN)) {
                pointSection.add(KEY_END);
            }
            geoLine.setAttributes(GeoHelper.getAttributes(pointSection));
        }
        return points;
    }

    static StringBuilder pointListToStringBuilder(Geo geo, LinkedList<GeoPoint> geoPoints, int indentLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t".repeat(indentLevel)).append("PointList ").append("\r\n");
        if (!geoPoints.isEmpty()) {
            sb.append("\t".repeat(indentLevel)).append(KEY_BEGIN).append("\r\n");
            for (GeoPoint geoPoint : geoPoints) {
                geoPoint.setGeo(geo);
                sb.append("\t".repeat(indentLevel + 1)).append(geoPoint.toString());
                if (geoPoint.getAttributes() == null) continue;
                sb.append("\t".repeat(indentLevel + 1)).append(KEY_BEGIN).append("\r\n");
                if (geoPoint.getAttributes().isEmpty()) {
                    sb.append("\t".repeat(indentLevel + 2)).append("AttributeList ").append("\r\n");
                } else {
                    sb.append((CharSequence)GeoHelper.attributeListToStringBuilder(geoPoint.getAttributes(), indentLevel + 2));
                }
                sb.append("\t".repeat(indentLevel + 1)).append(KEY_END).append("\r\n");
            }
            sb.append("\t".repeat(indentLevel)).append(KEY_END).append("\r\n");
        }
        return sb;
    }

    static void removeHead(List lines, int rows) {
        for (int i = 0; i < rows; ++i) {
            lines.remove(0);
        }
    }

    static void stripWrapper(LinkedList<String> section) {
        if (section.size() > 2) {
            GeoHelper.removeHead(section, 2);
            section.removeLast();
        }
    }

    static String toQuotedString(String s) {
        return StringUtils.isBlank((CharSequence)s) ? "" : "\"%s\"".formatted(s);
    }
}

