/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.io;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import se.trixon.almond.util.io.CoordinatePoint;
import se.trixon.almond.util.io.Geo;
import se.trixon.almond.util.io.GeoHelper;

public class GeoPoint
extends CoordinatePoint {
    private static String sLineEnding = "\r\n";
    private LinkedHashMap<String, String> mAttributes;
    private String mPointCode = "";
    private String mPointId = "";
    private String mRemark = "";
    private String mSpecialCode = "";
    private transient Geo mGeo;

    public static void setLineEnding(String lineEnding) {
        sLineEnding = lineEnding;
    }

    public GeoPoint() {
    }

    public GeoPoint(LinkedList<String> section) {
        this(section.pollFirst());
        if (!section.isEmpty()) {
            section.pollFirst();
            section.pollLast();
            if (!section.isEmpty()) {
                this.mAttributes = new LinkedHashMap();
                this.mAttributes.putAll(GeoHelper.getAttributes(section));
            }
        }
    }

    public GeoPoint(String row) throws NumberFormatException {
        row = StringUtils.removeStart((String)row.trim(), (String)"Point");
        String[] elements = this.getFirstItem(row);
        this.setPointId(elements[0]);
        String[] parts = StringUtils.splitPreserveAllTokens((String)elements[1], (String)",");
        this.setXRaw(parts[0]);
        this.setYRaw(parts[1]);
        this.setZRaw(parts[2]);
        elements[1] = StringUtils.substring((String)elements[1], (int)(StringUtils.ordinalIndexOf((CharSequence)elements[1], (CharSequence)",", (int)3) + 1));
        elements = this.getFirstItem(elements[1]);
        this.setPointCode(elements[0]);
        elements = this.getFirstItem(elements[1]);
        this.setSpecialCode(elements[0]);
        elements = this.getFirstItem(elements[1]);
        this.setRemark(elements[0]);
    }

    public GeoPoint(String pointId, Double x, Double y, Double z, String pointCode) {
        this.setPointId(pointId);
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        this.setPointCode(pointCode);
    }

    public LinkedHashMap<String, String> getAttributes() {
        return this.mAttributes;
    }

    public String getPointCode() {
        return this.mPointCode;
    }

    public String getPointId() {
        return this.mPointId;
    }

    public String getRemark() {
        return this.mRemark;
    }

    public String getSpecialCode() {
        return this.mSpecialCode;
    }

    public void setAttributes(LinkedHashMap<String, String> attributes) {
        this.mAttributes = attributes;
    }

    public void setPointCode(String pointCode) {
        this.mPointCode = pointCode;
    }

    public void setPointId(String pointId) {
        this.mPointId = pointId;
    }

    public void setRemark(String remark) {
        this.mRemark = remark;
    }

    public void setSpecialCode(String specialCode) {
        this.mSpecialCode = specialCode;
    }

    public String toString() {
        String row = "Point %s,%s,%s,%s,%s,%s,%s%s".formatted(GeoHelper.toQuotedString(this.getPointId()), this.getX(this.mGeo.getCoordinateFormat()), this.getY(this.mGeo.getCoordinateFormat()), this.getZ(this.mGeo.getCoordinateFormat()), GeoHelper.toQuotedString(this.getPointCode()), GeoHelper.toQuotedString(this.getSpecialCode()), GeoHelper.toQuotedString(this.getRemark()), sLineEnding);
        return row;
    }

    void setGeo(Geo geo) {
        this.mGeo = geo;
    }

    private String[] getFirstItem(String input) {
        String remaining;
        String segment;
        if (StringUtils.startsWith((CharSequence)(input = input.strip()), (CharSequence)",")) {
            segment = "";
            remaining = StringUtils.removeStart((String)input, (String)",");
        } else {
            int begin = StringUtils.ordinalIndexOf((CharSequence)input, (CharSequence)"\"", (int)1) + 1;
            int end = StringUtils.ordinalIndexOf((CharSequence)input, (CharSequence)"\"", (int)2);
            segment = StringUtils.substring((String)input, (int)begin, (int)end);
            remaining = StringUtils.substring((String)input, (int)(end + 2));
        }
        return new String[]{segment, remaining};
    }
}

