/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.io;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.StringUtils;
import se.trixon.almond.util.io.CoordinateFile;
import se.trixon.almond.util.io.PxyPoint;

public class Pxy
extends CoordinateFile {
    private static final Logger LOGGER = Logger.getLogger(Pxy.class.getName());
    private String mDate = "";
    private String mDescription = "";
    private String mIdText = "XYZ-COORD-FILE";
    private final List<PxyPoint> mPoints = new LinkedList<PxyPoint>();
    private String mReserved1 = "";
    private String mReserved2 = "";
    private String mVersion = "V1.00";

    public static FileNameExtensionFilter getFileNameExtensionFilter() {
        return new FileNameExtensionFilter("*.pxy", "pxy");
    }

    public Pxy() {
        this.mDate = LocalDate.now().format(DateTimeFormatter.ISO_DATE);
        PxyPoint.setLineEnding("\r\n");
    }

    public Pxy(Charset charset) {
        this();
        this.mCharset = charset;
    }

    public void addPoint(PxyPoint pxyPoint) {
        if (this.mPoints.isEmpty()) {
            this.mPath2D.moveTo(pxyPoint.getY(), pxyPoint.getX());
        } else {
            this.mPath2D.lineTo(pxyPoint.getY(), pxyPoint.getX());
        }
        this.mPoints.add(pxyPoint);
    }

    public void clear() {
        this.mPoints.clear();
    }

    public String getDate() {
        return this.mDate;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getIdText() {
        return this.mIdText;
    }

    public List<PxyPoint> getPoints() {
        return this.mPoints;
    }

    public String getReserved1() {
        return this.mReserved1;
    }

    public String getReserved2() {
        return this.mReserved2;
    }

    public String getVersion() {
        return this.mVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(File file) {
        boolean valid = false;
        try {
            this.read(file);
            valid = true;
        }
        catch (IOException | NumberFormatException | StringIndexOutOfBoundsException ex) {
            valid = false;
            LOGGER.warning(ex.getMessage());
        }
        finally {
            try {
                this.mReader.close();
            }
            catch (IOException iOException) {}
        }
        return valid;
    }

    @Override
    public void openWriter(File file) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("%-16s,".formatted(this.mIdText));
        builder.append("%-5s,".formatted(this.mVersion));
        builder.append("%-10s,".formatted(this.mDate));
        builder.append("%-40s".formatted(this.mReserved1));
        builder.append(",").append(this.mLineEnding);
        builder.append("%-40s,".formatted(this.mDescription));
        builder.append("%-33s".formatted(this.mReserved2));
        builder.append(",").append(this.mLineEnding);
        this.mWriter = Files.newBufferedWriter(file.toPath(), this.mCharset, new OpenOption[0]);
        this.mWriter.write(builder.toString());
    }

    public void read(File file) throws IOException, NumberFormatException, StringIndexOutOfBoundsException, MalformedInputException {
        this.mReader = Files.newBufferedReader(file.toPath(), this.mCharset);
        String line = this.mReader.readLine();
        this.setIdText(line.substring(0, 16));
        this.setVersion(line.substring(17, 22));
        this.setDate(line.substring(23, 33));
        this.setReserved1(line.substring(34, 73));
        line = this.mReader.readLine();
        this.setDescription(line.substring(0, 38));
        this.setReserved2(line.substring(41, 73));
        while ((line = this.mReader.readLine()) != null) {
            PxyPoint pxyPoint = new PxyPoint(line);
            if (this.mPoints.isEmpty()) {
                this.mPath2D.moveTo(pxyPoint.getY(), pxyPoint.getX());
            } else {
                this.mPath2D.lineTo(pxyPoint.getY(), pxyPoint.getX());
            }
            this.mPoints.add(pxyPoint);
        }
        this.mReader.close();
    }

    public void setDate(String date) {
        if (!(date = StringUtils.truncate((String)date, (int)10)).isEmpty()) {
            this.mDate = date;
        }
    }

    public void setDescription(String description) {
        this.mDescription = StringUtils.truncate((String)description, (int)39);
    }

    public void setIdText(String idText) {
        this.mIdText = StringUtils.truncate((String)idText, (int)16);
    }

    @Override
    public void setLineEnding(String lineEnding) {
        super.setLineEnding(lineEnding);
        PxyPoint.setLineEnding(lineEnding);
    }

    public void setReserved1(String reserved1) {
        this.mReserved1 = StringUtils.truncate((String)reserved1, (int)39);
    }

    public void setReserved2(String reserved2) {
        this.mReserved2 = StringUtils.truncate((String)reserved2, (int)33);
    }

    public void setVersion(String version) {
        this.mVersion = StringUtils.truncate((String)version, (int)5);
    }

    public void write(PxyPoint pxyPoint) throws IOException {
        this.mWriter.write(pxyPoint.toString());
    }

    public void write(File file) throws IOException {
        this.openWriter(file);
        for (PxyPoint pxyPoint : this.mPoints) {
            this.mWriter.write(pxyPoint.toString());
        }
        this.closeWriter();
    }
}

