/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.io;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import se.trixon.almond.util.io.CoordinatePoint;

public class PxyPoint
extends CoordinatePoint {
    private static final int MAX_DECIMALS = 4;
    private static String sLineEnding;
    private String mPointCode = "";
    private String mPointId = "";
    private String mRemark = "";
    private String mSpecialCode = "";
    private int mXYPrecision = 3;
    private int mZPrecision = 3;

    public static void setLineEnding(String lineEnding) {
        sLineEnding = lineEnding;
    }

    public PxyPoint() {
    }

    public PxyPoint(String line) throws NumberFormatException {
        this.setPointId(line.substring(0, 12));
        this.mX = Double.parseDouble(line.substring(14, 26));
        this.mY = Double.parseDouble(line.substring(26, 38));
        this.mZ = Double.parseDouble(line.substring(38, 50));
        this.setPointCode(line.substring(51, 59));
        this.setSpecialCode(line.substring(60, 62));
        this.setRemark(line.substring(62, 74));
    }

    public PxyPoint(String pointId, double x, double y, double z, String pointCode) {
        this.setPointId(pointId);
        this.mX = x;
        this.mY = y;
        this.mZ = z;
        this.setPointCode(pointCode);
    }

    public String getPointCode() {
        return this.mPointCode;
    }

    public String getPointId() {
        return this.mPointId;
    }

    public String getRemark() {
        return this.mRemark;
    }

    public String getSpecialCode() {
        return this.mSpecialCode;
    }

    public int getXYPrecision() {
        return this.mXYPrecision;
    }

    public int getZPrecision() {
        return this.mZPrecision;
    }

    public final void setPointCode(String pointCode) {
        this.mPointCode = StringUtils.truncate((String)pointCode, (int)8).trim();
    }

    public final void setPointId(String pointId) {
        this.mPointId = StringUtils.truncate((String)pointId, (int)12).trim();
    }

    public final void setRemark(String remark) {
        this.mRemark = StringUtils.truncate((String)remark, (int)12).trim();
    }

    public final void setSpecialCode(String specialCode) {
        this.mSpecialCode = StringUtils.truncate((String)specialCode, (int)2).trim();
    }

    public void setXYPrecision(int xyPrecision) {
        this.mXYPrecision = Math.min(xyPrecision, 4);
    }

    public void setZPrecision(int zPrecision) {
        this.mZPrecision = Math.min(zPrecision, 4);
    }

    public String toString() {
        int xyInt = this.mXYPrecision == 0 ? 1 : 0;
        int zInt = this.mZPrecision == 0 ? 1 : 0;
        int paddingXY = 4 - this.mXYPrecision;
        if (paddingXY == 4) {
            ++paddingXY;
        }
        String xyPadding = new String(new char[paddingXY]).replace("\\0", " ");
        int paddingZ = 4 - this.mZPrecision;
        if (paddingZ == 4) {
            ++paddingZ;
        }
        String zPadding = new String(new char[paddingZ]).replace("\\0", " ");
        String xyFormat = String.format(Locale.ENGLISH, "%%%d.%df", 8 + this.mXYPrecision - xyInt, this.mXYPrecision);
        String zFormat = String.format(Locale.ENGLISH, "%%%d.%df", 8 + this.mZPrecision - zInt, this.mZPrecision);
        StringBuilder builder = new StringBuilder();
        builder.append("%-12s".formatted(this.mPointId));
        builder.append("  ");
        builder.append(String.format(Locale.ENGLISH, xyFormat, this.mX)).append(xyPadding);
        builder.append(String.format(Locale.ENGLISH, xyFormat, this.mY)).append(xyPadding);
        builder.append(String.format(Locale.ENGLISH, zFormat, this.mZ)).append(zPadding);
        builder.append(" ");
        builder.append("%-8s".formatted(this.mPointCode));
        builder.append(" ");
        builder.append("%-2s".formatted(this.mSpecialCode));
        builder.append("%-12s".formatted(this.mRemark));
        builder.append(",").append(sLineEnding);
        return builder.toString();
    }
}

