/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.swing;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import se.trixon.almond.util.Dict;

public class ColorPanel
extends JPanel {
    private Color mColor;
    private final JColorChooser mColorChooser = new JColorChooser();
    private JComponent mDialogParent = null;
    private transient ColorChangeListener mColorChangeListener;

    public ColorPanel() {
        this.initComponents();
        this.setColor(Color.BLACK);
    }

    public Color getColor() {
        return this.mColor;
    }

    public ColorChangeListener getColorChangeListener() {
        return this.mColorChangeListener;
    }

    public void setColor(Color color) {
        this.mColor = color;
        this.setBackground(color);
    }

    public void setColorChangeListener(ColorChangeListener colorChangeListener) {
        this.mColorChangeListener = colorChangeListener;
    }

    public void setDialogParent(JComponent dialogParent) {
        this.mDialogParent = dialogParent;
    }

    private void initComponents() {
        this.setBackground(new Color(102, 255, 51));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ColorPanel.this.formMousePressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 396, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 296, Short.MAX_VALUE));
    }

    private void formMousePressed(MouseEvent evt) {
        if (!this.isEnabled()) {
            return;
        }
        Color oldColor = new Color(this.mColor.getRGB());
        this.mColorChooser.setColor(this.mColor);
        Object[] options = new Object[]{Dict.CANCEL, Dict.OK};
        int retval = JOptionPane.showOptionDialog(this.mDialogParent, this.mColorChooser, Dict.Dialog.TITLE_SELECT_COLOR.toString(), -1, -1, null, options, (Object)Dict.OK);
        if (retval == Arrays.asList(options).indexOf((Object)Dict.OK)) {
            this.setColor(this.mColorChooser.getColor());
            if (this.mColorChangeListener != null && !oldColor.equals(this.mColor)) {
                this.mColorChangeListener.onColorChanged(oldColor, this.mColor);
            }
        }
    }

    public static interface ColorChangeListener {
        public void onColorChanged(Color var1, Color var2);
    }
}

