/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.swing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.commons.lang3.StringUtils;

public class LocaleComboBox
extends JComboBox<String> {
    public LocaleComboBox() {
        this.initialize();
    }

    public Locale getSelectedLocale() {
        for (Locale locale : Locale.getAvailableLocales()) {
            if (!StringUtils.equals((CharSequence)((String)this.getSelectedItem()), (CharSequence)locale.getDisplayName())) continue;
            return locale;
        }
        return null;
    }

    public void setSelectedLocale(Locale locale) {
        this.setSelectedItem(locale.getDisplayName());
    }

    private void initialize() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        ArrayList<Locale> locales = new ArrayList<Locale>(Arrays.asList(Locale.getAvailableLocales()));
        locales.sort((o1, o2) -> o1.getDisplayName().compareTo(o2.getDisplayName()));
        locales.forEach(locale -> model.addElement(locale.getDisplayName()));
        this.setModel(model);
        this.setSelectedLocale(Locale.getDefault());
    }
}

